/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import java.util.Arrays;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationMetadataConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasPersonDirectoryConfiguration;
import org.apereo.cas.config.HazelcastTicketRegistryConfiguration;
import org.apereo.cas.config.support.EnvironmentConversionServiceInitializer;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.ticket.registry.HazelcastTicketRegistryReplicationTests;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={HazelcastTicketRegistryReplicationTests.HazelcastTestConfiguration.class, HazelcastTicketRegistryConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreUtilConfiguration.class, CasCoreConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationMetadataConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasCoreHttpConfiguration.class, CasCoreServicesConfiguration.class, CasCoreLogoutConfiguration.class, RefreshAutoConfiguration.class, CasPersonDirectoryConfiguration.class, CasCoreLogoutConfiguration.class})
@ContextConfiguration(locations={"classpath:HazelcastInstanceConfigurationTests-config.xml"}, initializers={EnvironmentConversionServiceInitializer.class})
@TestPropertySource(locations={"classpath:/hazelcast.properties"})
@DirtiesContext
public class ProvidedHazelcastInstanceConfigurationTests {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProvidedHazelcastInstanceConfigurationTests.class);
    @Autowired
    @Qualifier(value="hazelcast")
    private HazelcastInstance hzInstance;

    @Test
    public void hazelcastInstanceIsCreatedNormally() throws Exception {
        Assert.assertNotNull((Object)this.hzInstance);
        Config config = this.hzInstance.getConfig();
        Assert.assertTrue((boolean)config.getNetworkConfig().getJoin().getMulticastConfig().isEnabled());
        Assert.assertEquals(Arrays.asList("127.0.0.1"), (Object)config.getNetworkConfig().getJoin().getTcpIpConfig().getMembers());
        Assert.assertFalse((boolean)config.getNetworkConfig().isPortAutoIncrement());
        Assert.assertEquals((long)5801L, (long)config.getNetworkConfig().getPort());
        MapConfig mapConfig = config.getMapConfig("tickets-from-external-config");
        Assert.assertNotNull((Object)mapConfig);
        Assert.assertEquals((long)20000L, (long)mapConfig.getMaxIdleSeconds());
        Assert.assertEquals((Object)EvictionPolicy.LFU, (Object)mapConfig.getEvictionPolicy());
        Assert.assertEquals((long)99L, (long)mapConfig.getEvictionPercentage());
    }

    @After
    public void shutdownHz() {
        LOGGER.info("Shutting down hazelcast instance [{}]", (Object)this.hzInstance.getConfig().getInstanceName());
        this.hzInstance.shutdown();
        while (this.hzInstance.getLifecycleService().isRunning()) {
            LOGGER.info("Waiting for instances to shut down");
        }
    }
}

