/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import java.util.Collection;
import javax.annotation.PostConstruct;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationMetadataConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasPersonDirectoryConfiguration;
import org.apereo.cas.config.HazelcastTicketRegistryTicketCatalogConfiguration;
import org.apereo.cas.config.support.EnvironmentConversionServiceInitializer;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.mock.MockServiceTicket;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.registry.HazelcastTicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.apereo.cas.util.SchedulingUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@ContextConfiguration(initializers={EnvironmentConversionServiceInitializer.class}, locations={"classpath:HazelcastTicketRegistryTests-context.xml"})
@SpringBootTest(classes={HazelcastTestConfiguration.class, RefreshAutoConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreLogoutConfiguration.class, CasCoreHttpConfiguration.class, CasCoreServicesConfiguration.class, CasCoreConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationMetadataConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasPersonDirectoryConfiguration.class, HazelcastTicketRegistryTicketCatalogConfiguration.class, CasCoreTicketCatalogConfiguration.class})
public class HazelcastTicketRegistryReplicationTests {
    private static final String TGT_ID = "TGT";
    private static final String ST_ID_1 = "ST1";
    private static final String PGT_ID_1 = "PGT-1";
    @Autowired
    @Qualifier(value="hzTicketRegistry1")
    private TicketRegistry hzTicketRegistry1;
    @Autowired
    @Qualifier(value="hzTicketRegistry2")
    private TicketRegistry hzTicketRegistry2;

    public void setHzTicketRegistry1(HazelcastTicketRegistry hzTicketRegistry1) {
        this.hzTicketRegistry1 = hzTicketRegistry1;
    }

    public void setHzTicketRegistry2(HazelcastTicketRegistry hzTicketRegistry2) {
        this.hzTicketRegistry2 = hzTicketRegistry2;
    }

    @Test
    public void retrieveCollectionOfTickets() {
        Collection col = this.hzTicketRegistry1.getTickets();
        col.forEach(ticket -> this.hzTicketRegistry1.deleteTicket(ticket.getId()));
        col = this.hzTicketRegistry2.getTickets();
        Assert.assertEquals((long)0L, (long)col.size());
        TicketGrantingTicket tgt = HazelcastTicketRegistryReplicationTests.newTestTgt();
        this.hzTicketRegistry1.addTicket((Ticket)tgt);
        this.hzTicketRegistry1.addTicket((Ticket)HazelcastTicketRegistryReplicationTests.newTestSt(tgt));
        col = this.hzTicketRegistry2.getTickets();
        Assert.assertEquals((long)2L, (long)col.size());
        Assert.assertEquals((long)1L, (long)this.hzTicketRegistry2.serviceTicketCount());
        Assert.assertEquals((long)1L, (long)this.hzTicketRegistry2.sessionCount());
    }

    @Test
    public void basicOperationsAndClustering() throws Exception {
        TicketGrantingTicket tgt = HazelcastTicketRegistryReplicationTests.newTestTgt();
        this.hzTicketRegistry1.addTicket((Ticket)tgt);
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket(tgt.getId()));
        Assert.assertNotNull((Object)this.hzTicketRegistry2.getTicket(tgt.getId()));
        Assert.assertEquals((long)1L, (long)this.hzTicketRegistry2.deleteTicket(tgt.getId()));
        Assert.assertEquals((long)0L, (long)this.hzTicketRegistry1.deleteTicket(tgt.getId()));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket(tgt.getId()));
        Assert.assertNull((Object)this.hzTicketRegistry2.getTicket(tgt.getId()));
        ServiceTicket st = HazelcastTicketRegistryReplicationTests.newTestSt(tgt);
        this.hzTicketRegistry2.addTicket((Ticket)st);
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket("ST-TEST"));
        Assert.assertNotNull((Object)this.hzTicketRegistry2.getTicket("ST-TEST"));
        Assert.assertEquals((long)1L, (long)this.hzTicketRegistry1.deleteTicket("ST-TEST"));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket("ST-TEST"));
        Assert.assertNull((Object)this.hzTicketRegistry2.getTicket("ST-TEST"));
    }

    @Test
    public void verifyDeleteTicketWithChildren() throws Exception {
        this.hzTicketRegistry1.addTicket((Ticket)new TicketGrantingTicketImpl(TGT_ID, CoreAuthenticationTestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
        TicketGrantingTicket tgt = (TicketGrantingTicket)this.hzTicketRegistry1.getTicket(TGT_ID, TicketGrantingTicket.class);
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)"TGT_DELETE_TEST");
        ServiceTicket st1 = tgt.grantServiceTicket(ST_ID_1, (Service)service, (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false, false);
        ServiceTicket st2 = tgt.grantServiceTicket("ST2", (Service)service, (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false, false);
        ServiceTicket st3 = tgt.grantServiceTicket("ST3", (Service)service, (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false, false);
        this.hzTicketRegistry1.addTicket((Ticket)st1);
        this.hzTicketRegistry1.addTicket((Ticket)st2);
        this.hzTicketRegistry1.addTicket((Ticket)st3);
        this.hzTicketRegistry1.updateTicket((Ticket)tgt);
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket(tgt.getId(), TicketGrantingTicket.class));
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket(ST_ID_1, ServiceTicket.class));
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket("ST2", ServiceTicket.class));
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket("ST3", ServiceTicket.class));
        Assert.assertTrue((String)"TGT and children were deleted", (this.hzTicketRegistry1.deleteTicket(tgt.getId()) > 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket(tgt.getId(), TicketGrantingTicket.class));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket(ST_ID_1, ServiceTicket.class));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket("ST2", ServiceTicket.class));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket("ST3", ServiceTicket.class));
    }

    @Test
    public void verifyDeleteTicketWithPGT() {
        Authentication a = CoreAuthenticationTestUtils.getAuthentication();
        this.hzTicketRegistry1.addTicket((Ticket)new TicketGrantingTicketImpl(TGT_ID, a, (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
        TicketGrantingTicket tgt = (TicketGrantingTicket)this.hzTicketRegistry1.getTicket(TGT_ID, TicketGrantingTicket.class);
        AbstractWebApplicationService service = RegisteredServiceTestUtils.getService((String)"TGT_DELETE_TEST");
        ServiceTicket st1 = tgt.grantServiceTicket(ST_ID_1, (Service)service, (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false, true);
        this.hzTicketRegistry1.addTicket((Ticket)st1);
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket(TGT_ID, TicketGrantingTicket.class));
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket(ST_ID_1, ServiceTicket.class));
        ProxyGrantingTicket pgt = st1.grantProxyGrantingTicket(PGT_ID_1, a, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        Assert.assertEquals((Object)a, (Object)pgt.getAuthentication());
        this.hzTicketRegistry1.addTicket((Ticket)pgt);
        this.hzTicketRegistry1.updateTicket((Ticket)tgt);
        Assert.assertSame((Object)3, (Object)this.hzTicketRegistry1.deleteTicket(tgt.getId()));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket(TGT_ID, TicketGrantingTicket.class));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket(ST_ID_1, ServiceTicket.class));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket(PGT_ID_1, ProxyGrantingTicket.class));
    }

    private static TicketGrantingTicket newTestTgt() {
        return new MockTicketGrantingTicket("casuser");
    }

    private static ServiceTicket newTestSt(TicketGrantingTicket tgt) {
        return new MockServiceTicket("ST-TEST", RegisteredServiceTestUtils.getService(), tgt);
    }

    @TestConfiguration
    public static class HazelcastTestConfiguration {
        @Autowired
        protected ApplicationContext applicationContext;

        @PostConstruct
        public void init() {
            SchedulingUtils.prepScheduledAnnotationBeanPostProcessor((ApplicationContext)this.applicationContext);
        }
    }
}

