/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.AbstractTicketRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HazelcastTicketRegistry
extends AbstractTicketRegistry
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HazelcastTicketRegistry.class);
    private IMap<String, Ticket> registry;
    private HazelcastInstance hazelcastInstance;
    private int pageSize;

    public HazelcastTicketRegistry(HazelcastInstance hz, String mapName, int pageSize) {
        this.registry = hz.getMap(mapName);
        this.hazelcastInstance = hz;
        this.pageSize = pageSize;
    }

    @PostConstruct
    public void init() {
        LOGGER.info("Setting up Hazelcast Ticket Registry instance [{}] with name [{}]", (Object)this.hazelcastInstance, (Object)this.registry.getName());
    }

    public Ticket updateTicket(Ticket ticket) {
        this.addTicket(ticket);
        return ticket;
    }

    public void addTicket(Ticket ticket) {
        LOGGER.debug("Adding ticket [{}] with ttl [{}s]", (Object)ticket.getId(), (Object)ticket.getExpirationPolicy().getTimeToLive());
        Ticket encTicket = this.encodeTicket(ticket);
        this.registry.set((Object)encTicket.getId(), (Object)encTicket, ticket.getExpirationPolicy().getTimeToLive().longValue(), TimeUnit.SECONDS);
    }

    public Ticket getTicket(String ticketId) {
        String encTicketId = this.encodeTicketId(ticketId);
        if (StringUtils.isNotBlank((CharSequence)encTicketId)) {
            Ticket ticket = (Ticket)this.registry.get((Object)encTicketId);
            return this.decodeTicket(ticket);
        }
        return null;
    }

    public boolean deleteSingleTicket(String ticketId) {
        return this.registry.remove((Object)ticketId) != null;
    }

    public long deleteAll() {
        int size = this.registry.size();
        this.registry.evictAll();
        this.registry.clear();
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Ticket> getTickets() {
        HashSet<Ticket> collection = new HashSet<Ticket>();
        LOGGER.debug("Attempting to acquire lock from Hazelcast instance...");
        ILock lock = this.hazelcastInstance.getLock(this.getClass().getName());
        lock.lock();
        LOGGER.debug("Hazelcast instance lock acquired");
        try {
            LOGGER.debug("Setting up the paging predicate with page size of [{}]", (Object)this.pageSize);
            PagingPredicate pagingPredicate = new PagingPredicate(this.pageSize);
            LOGGER.debug("Retrieving the initial collection of tickets from Hazelcast instance...");
            Collection entrySet = this.registry.values((Predicate)pagingPredicate);
            while (!entrySet.isEmpty()) {
                collection.addAll(entrySet.stream().map(arg_0 -> ((HazelcastTicketRegistry)this).decodeTicket(arg_0)).collect(Collectors.toList()));
                pagingPredicate.nextPage();
                entrySet = this.registry.values((Predicate)pagingPredicate);
            }
        }
        catch (Exception e) {
            LOGGER.debug(e.getMessage(), (Throwable)e);
        }
        finally {
            lock.unlock();
        }
        return collection;
    }

    @PreDestroy
    public void shutdown() {
        try {
            LOGGER.info("Shutting down Hazelcast instance [{}]", (Object)this.hazelcastInstance.getConfig().getInstanceName());
            this.hazelcastInstance.shutdown();
        }
        catch (Throwable e) {
            LOGGER.debug(e.getMessage());
        }
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }
}

