/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.google.common.base.Throwables;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.CryptographyProperties;
import org.apereo.cas.configuration.model.support.hazelcast.HazelcastProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.registry.HazelcastTicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.util.StringUtils;

@Configuration(value="hazelcastInstanceConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableAspectJAutoProxy(proxyTargetClass=true)
public class HazelcastInstanceConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean
    public TicketRegistry ticketRegistry() {
        HazelcastProperties hazelcast = this.casProperties.getTicket().getRegistry().getHazelcast();
        HazelcastTicketRegistry r = new HazelcastTicketRegistry(this.hazelcast(), hazelcast.getMapName(), hazelcast.getPageSize());
        r.setCipherExecutor(Beans.newTicketRegistryCipherExecutor((CryptographyProperties)hazelcast.getCrypto()));
        return r;
    }

    @Bean
    public HazelcastInstance hazelcast() {
        try {
            Config cfg = this.getConfig();
            cfg.setClassLoader(this.getClass().getClassLoader());
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            return Hazelcast.getOrCreateHazelcastInstance((Config)cfg);
        }
        catch (Throwable e) {
            throw new BeanCreationException(e.getMessage(), e);
        }
    }

    private Config getConfig() {
        Config config;
        HazelcastProperties hazelcast = this.casProperties.getTicket().getRegistry().getHazelcast();
        HazelcastProperties.Cluster cluster = hazelcast.getCluster();
        if (hazelcast.getConfigLocation() != null && hazelcast.getConfigLocation().exists()) {
            try {
                URL configUrl = hazelcast.getConfigLocation().getURL();
                config = new XmlConfigBuilder(hazelcast.getConfigLocation().getInputStream()).build();
                config.setConfigurationUrl(configUrl);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else {
            config = new Config();
            config.setProperty("hazelcast.prefer.ipv4.stack", String.valueOf(cluster.isIpv4Enabled()));
            TcpIpConfig tcpIpConfig = new TcpIpConfig().setEnabled(cluster.isTcpipEnabled()).setMembers(cluster.getMembers()).setConnectionTimeoutSeconds(cluster.getTimeout());
            MulticastConfig multicastConfig = new MulticastConfig().setEnabled(cluster.isMulticastEnabled());
            if (cluster.isMulticastEnabled()) {
                multicastConfig.setMulticastGroup(cluster.getMulticastGroup());
                multicastConfig.setMulticastPort(cluster.getMulticastPort());
                Set trustedInterfaces = StringUtils.commaDelimitedListToSet((String)cluster.getMulticastTrustedInterfaces());
                if (!trustedInterfaces.isEmpty()) {
                    multicastConfig.setTrustedInterfaces(trustedInterfaces);
                }
                multicastConfig.setMulticastTimeoutSeconds(cluster.getMulticastTimeout());
                multicastConfig.setMulticastTimeToLive(cluster.getMulticastTimeToLive());
            }
            JoinConfig joinConfig = new JoinConfig().setMulticastConfig(multicastConfig).setTcpIpConfig(tcpIpConfig);
            NetworkConfig networkConfig = new NetworkConfig().setPort(cluster.getPort()).setPortAutoIncrement(cluster.isPortAutoIncrement()).setJoin(joinConfig);
            MapConfig mapConfig = new MapConfig().setName(hazelcast.getMapName()).setMaxIdleSeconds(this.casProperties.getTicket().getTgt().getMaxTimeToLiveInSeconds()).setBackupCount(cluster.getBackupCount()).setAsyncBackupCount(cluster.getAsyncBackupCount()).setEvictionPolicy(EvictionPolicy.valueOf((String)cluster.getEvictionPolicy())).setEvictionPercentage(cluster.getEvictionPercentage()).setMaxSizeConfig(new MaxSizeConfig().setMaxSizePolicy(MaxSizeConfig.MaxSizePolicy.valueOf((String)cluster.getMaxSizePolicy())).setSize(cluster.getMaxHeapSizePercentage()));
            HashMap<String, MapConfig> mapConfigs = new HashMap<String, MapConfig>();
            mapConfigs.put(hazelcast.getMapName(), mapConfig);
            config.setMapConfigs(mapConfigs).setNetworkConfig(networkConfig);
        }
        return config.setInstanceName(cluster.getInstanceName()).setProperty("hazelcast.logging.type", cluster.getLoggingType()).setProperty("hazelcast.max.no.heartbeat.seconds", String.valueOf(cluster.getMaxNoHeartbeatSeconds()));
    }
}

