/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import java.util.Collection;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.TestUtils;
import org.apereo.cas.authentication.principal.AbstractWebApplicationService;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.mock.MockServiceTicket;
import org.apereo.cas.mock.MockTicketGrantingTicket;
import org.apereo.cas.ticket.ExpirationPolicy;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketGrantingTicket;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.registry.HazelcastTicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.support.NeverExpiresExpirationPolicy;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@ContextConfiguration(locations={"classpath:HazelcastTicketRegistryTests-context.xml"})
@SpringBootTest(classes={RefreshAutoConfiguration.class})
public class HazelcastTicketRegistryTests {
    @Autowired
    @Qualifier(value="hzTicketRegistry1")
    private TicketRegistry hzTicketRegistry1;
    @Autowired
    @Qualifier(value="hzTicketRegistry2")
    private TicketRegistry hzTicketRegistry2;

    public void setHzTicketRegistry1(HazelcastTicketRegistry hzTicketRegistry1) {
        this.hzTicketRegistry1 = hzTicketRegistry1;
    }

    public void setHzTicketRegistry2(HazelcastTicketRegistry hzTicketRegistry2) {
        this.hzTicketRegistry2 = hzTicketRegistry2;
    }

    @Test
    public void retrieveCollectionOfTickets() {
        Collection col = this.hzTicketRegistry1.getTickets();
        for (Ticket ticket : col) {
            this.hzTicketRegistry1.deleteTicket(ticket.getId());
        }
        col = this.hzTicketRegistry2.getTickets();
        Assert.assertEquals((long)0L, (long)col.size());
        TicketGrantingTicket tgt = HazelcastTicketRegistryTests.newTestTgt();
        this.hzTicketRegistry1.addTicket((Ticket)tgt);
        this.hzTicketRegistry1.addTicket((Ticket)HazelcastTicketRegistryTests.newTestSt(tgt));
        col = this.hzTicketRegistry2.getTickets();
        Assert.assertEquals((long)2L, (long)col.size());
        Assert.assertEquals((long)1L, (long)this.hzTicketRegistry2.serviceTicketCount());
        Assert.assertEquals((long)1L, (long)this.hzTicketRegistry2.sessionCount());
    }

    @Test
    public void basicOperationsAndClustering() throws Exception {
        TicketGrantingTicket tgt = HazelcastTicketRegistryTests.newTestTgt();
        this.hzTicketRegistry1.addTicket((Ticket)tgt);
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket(tgt.getId()));
        Assert.assertNotNull((Object)this.hzTicketRegistry2.getTicket(tgt.getId()));
        Assert.assertEquals((long)1L, (long)this.hzTicketRegistry2.deleteTicket(tgt.getId()));
        Assert.assertEquals((long)0L, (long)this.hzTicketRegistry1.deleteTicket(tgt.getId()));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket(tgt.getId()));
        Assert.assertNull((Object)this.hzTicketRegistry2.getTicket(tgt.getId()));
        ServiceTicket st = HazelcastTicketRegistryTests.newTestSt(tgt);
        this.hzTicketRegistry2.addTicket((Ticket)st);
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket("ST-TEST"));
        Assert.assertNotNull((Object)this.hzTicketRegistry2.getTicket("ST-TEST"));
        Assert.assertEquals((long)1L, (long)this.hzTicketRegistry1.deleteTicket("ST-TEST"));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket("ST-TEST"));
        Assert.assertNull((Object)this.hzTicketRegistry2.getTicket("ST-TEST"));
    }

    @Test
    public void verifyDeleteTicketWithChildren() throws Exception {
        this.hzTicketRegistry1.addTicket((Ticket)new TicketGrantingTicketImpl("TGT", TestUtils.getAuthentication(), (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
        TicketGrantingTicket tgt = (TicketGrantingTicket)this.hzTicketRegistry1.getTicket("TGT", TicketGrantingTicket.class);
        AbstractWebApplicationService service = org.apereo.cas.services.TestUtils.getService((String)"TGT_DELETE_TEST");
        ServiceTicket st1 = tgt.grantServiceTicket("ST1", (Service)service, (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false, false);
        ServiceTicket st2 = tgt.grantServiceTicket("ST2", (Service)service, (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false, false);
        ServiceTicket st3 = tgt.grantServiceTicket("ST3", (Service)service, (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false, false);
        this.hzTicketRegistry1.addTicket((Ticket)st1);
        this.hzTicketRegistry1.addTicket((Ticket)st2);
        this.hzTicketRegistry1.addTicket((Ticket)st3);
        this.hzTicketRegistry1.updateTicket((Ticket)tgt);
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket(tgt.getId(), TicketGrantingTicket.class));
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket("ST1", ServiceTicket.class));
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket("ST2", ServiceTicket.class));
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket("ST3", ServiceTicket.class));
        Assert.assertTrue((String)"TGT and children were deleted", (this.hzTicketRegistry1.deleteTicket(tgt.getId()) > 0 ? 1 : 0) != 0);
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket(tgt.getId(), TicketGrantingTicket.class));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket("ST1", ServiceTicket.class));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket("ST2", ServiceTicket.class));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket("ST3", ServiceTicket.class));
    }

    @Test
    public void verifyDeleteTicketWithPGT() {
        Authentication a = TestUtils.getAuthentication();
        this.hzTicketRegistry1.addTicket((Ticket)new TicketGrantingTicketImpl("TGT", a, (ExpirationPolicy)new NeverExpiresExpirationPolicy()));
        TicketGrantingTicket tgt = (TicketGrantingTicket)this.hzTicketRegistry1.getTicket("TGT", TicketGrantingTicket.class);
        AbstractWebApplicationService service = org.apereo.cas.services.TestUtils.getService((String)"TGT_DELETE_TEST");
        ServiceTicket st1 = tgt.grantServiceTicket("ST1", (Service)service, (ExpirationPolicy)new NeverExpiresExpirationPolicy(), false, true);
        this.hzTicketRegistry1.addTicket((Ticket)st1);
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket("TGT", TicketGrantingTicket.class));
        Assert.assertNotNull((Object)this.hzTicketRegistry1.getTicket("ST1", ServiceTicket.class));
        ProxyGrantingTicket pgt = st1.grantProxyGrantingTicket("PGT-1", a, (ExpirationPolicy)new NeverExpiresExpirationPolicy());
        Assert.assertEquals((Object)a, (Object)pgt.getAuthentication());
        this.hzTicketRegistry1.addTicket((Ticket)pgt);
        this.hzTicketRegistry1.updateTicket((Ticket)tgt);
        Assert.assertSame((Object)3, (Object)this.hzTicketRegistry1.deleteTicket(tgt.getId()));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket("TGT", TicketGrantingTicket.class));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket("ST1", ServiceTicket.class));
        Assert.assertNull((Object)this.hzTicketRegistry1.getTicket("PGT-1", ProxyGrantingTicket.class));
    }

    private static TicketGrantingTicket newTestTgt() {
        return new MockTicketGrantingTicket("casuser");
    }

    private static ServiceTicket newTestSt(TicketGrantingTicket tgt) {
        return new MockServiceTicket("ST-TEST", org.apereo.cas.services.TestUtils.getService(), tgt);
    }
}

