/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.ILock;
import com.hazelcast.core.IMap;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.Predicate;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.AbstractTicketRegistry;

public class HazelcastTicketRegistry
extends AbstractTicketRegistry
implements Closeable {
    private IMap<String, Ticket> registry;
    private HazelcastInstance hazelcastInstance;
    private int pageSize;

    public HazelcastTicketRegistry() {
    }

    public HazelcastTicketRegistry(HazelcastInstance hz, String mapName, int pageSize) {
        this.registry = hz.getMap(mapName);
        this.hazelcastInstance = hz;
        this.pageSize = pageSize;
    }

    @PostConstruct
    public void init() {
        this.logger.info("Setting up Hazelcast Ticket Registry instance {} with name {}", (Object)this.hazelcastInstance, (Object)this.registry.getName());
    }

    public void updateTicket(Ticket ticket) {
        this.addTicket(ticket);
    }

    public void addTicket(Ticket ticket) {
        this.logger.debug("Adding ticket [{}] with ttl [{}s]", (Object)ticket.getId(), (Object)ticket.getExpirationPolicy().getTimeToLive());
        Ticket encTicket = this.encodeTicket(ticket);
        this.registry.set((Object)encTicket.getId(), (Object)encTicket, ticket.getExpirationPolicy().getTimeToLive().longValue(), TimeUnit.SECONDS);
    }

    public Ticket getTicket(String ticketId) {
        String encTicketId = this.encodeTicketId(ticketId);
        return this.decodeTicket((Ticket)this.registry.get((Object)encTicketId));
    }

    public boolean deleteSingleTicket(String ticketId) {
        return this.registry.remove((Object)ticketId) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Ticket> getTickets() {
        HashSet<Ticket> collection = new HashSet<Ticket>();
        ILock lock = this.hazelcastInstance.getLock(this.getClass().getName());
        lock.lock();
        try {
            PagingPredicate pagingPredicate = new PagingPredicate(this.pageSize);
            Collection entrySet = this.registry.values((Predicate)pagingPredicate);
            while (!entrySet.isEmpty()) {
                collection.addAll(entrySet.stream().map(arg_0 -> ((HazelcastTicketRegistry)this).decodeTicket(arg_0)).collect(Collectors.toList()));
                pagingPredicate.nextPage();
                entrySet = this.registry.values((Predicate)pagingPredicate);
            }
        }
        finally {
            lock.unlock();
        }
        return collection;
    }

    @PreDestroy
    public void shutdown() {
        this.logger.info("Shutting down Hazelcast instance {}", (Object)this.hazelcastInstance.getConfig().getInstanceName());
        try {
            this.hazelcastInstance.shutdown();
        }
        catch (Throwable e) {
            this.logger.debug(e.getMessage());
        }
    }

    public void setRegistry(IMap<String, Ticket> registry) {
        this.registry = registry;
    }

    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }
}

