/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.google.common.base.Throwables;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.JoinConfig;
import com.hazelcast.config.MapConfig;
import com.hazelcast.config.MaxSizeConfig;
import com.hazelcast.config.MulticastConfig;
import com.hazelcast.config.NetworkConfig;
import com.hazelcast.config.TcpIpConfig;
import com.hazelcast.config.XmlConfigBuilder;
import com.hazelcast.core.Hazelcast;
import com.hazelcast.core.HazelcastInstance;
import java.net.URL;
import java.util.HashMap;
import java.util.Set;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.CryptographyProperties;
import org.apereo.cas.configuration.model.support.hazelcast.HazelcastProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.ticket.registry.HazelcastTicketRegistry;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(value="hazelcastInstanceConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class HazelcastInstanceConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @Bean(name={"hazelcastTicketRegistry", "ticketRegistry"})
    @RefreshScope
    public TicketRegistry hazelcastTicketRegistry() {
        HazelcastTicketRegistry r = new HazelcastTicketRegistry(this.hazelcast(), this.casProperties.getTicket().getRegistry().getHazelcast().getMapName(), this.casProperties.getTicket().getRegistry().getHazelcast().getPageSize());
        r.setCipherExecutor(Beans.newTicketRegistryCipherExecutor((CryptographyProperties)this.casProperties.getTicket().getRegistry().getHazelcast().getCrypto()));
        return r;
    }

    @Bean
    public HazelcastInstance hazelcast() {
        return Hazelcast.newHazelcastInstance((Config)this.getConfig());
    }

    private Config getConfig() {
        Config config;
        HazelcastProperties.Cluster cluster = this.casProperties.getTicket().getRegistry().getHazelcast().getCluster();
        if (this.casProperties.getTicket().getRegistry().getHazelcast().getConfigLocation() != null && this.casProperties.getTicket().getRegistry().getHazelcast().getConfigLocation().exists()) {
            try {
                URL configUrl = this.casProperties.getTicket().getRegistry().getHazelcast().getConfigLocation().getURL();
                config = new XmlConfigBuilder(this.casProperties.getTicket().getRegistry().getHazelcast().getConfigLocation().getInputStream()).build();
                config.setConfigurationUrl(configUrl);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        } else {
            config = new Config();
            config.setProperty("hazelcast.prefer.ipv4.stack", String.valueOf(cluster.isIpv4Enabled()));
            TcpIpConfig tcpIpConfig = new TcpIpConfig().setEnabled(cluster.isTcpipEnabled()).setMembers(cluster.getMembers()).setConnectionTimeoutSeconds(cluster.getTimeout());
            MulticastConfig multicastConfig = new MulticastConfig().setEnabled(cluster.isMulticastEnabled());
            if (cluster.isMulticastEnabled()) {
                multicastConfig.setMulticastGroup(cluster.getMulticastGroup());
                multicastConfig.setMulticastPort(cluster.getMulticastPort());
                Set trustedInterfaces = StringUtils.commaDelimitedListToSet((String)cluster.getMulticastTrustedInterfaces());
                if (!trustedInterfaces.isEmpty()) {
                    multicastConfig.setTrustedInterfaces(trustedInterfaces);
                }
                multicastConfig.setMulticastTimeoutSeconds(cluster.getMulticastTimeout());
                multicastConfig.setMulticastTimeToLive(cluster.getMulticastTimeToLive());
            }
            JoinConfig joinConfig = new JoinConfig().setMulticastConfig(multicastConfig).setTcpIpConfig(tcpIpConfig);
            NetworkConfig networkConfig = new NetworkConfig().setPort(cluster.getPort()).setPortAutoIncrement(cluster.isPortAutoIncrement()).setJoin(joinConfig);
            MapConfig mapConfig = new MapConfig().setName(this.casProperties.getTicket().getRegistry().getHazelcast().getMapName()).setMaxIdleSeconds(this.casProperties.getTicket().getTgt().getMaxTimeToLiveInSeconds()).setBackupCount(cluster.getBackupCount()).setAsyncBackupCount(cluster.getAsyncBackupCount()).setEvictionPolicy(EvictionPolicy.valueOf((String)cluster.getEvictionPolicy())).setEvictionPercentage(cluster.getEvictionPercentage()).setMaxSizeConfig(new MaxSizeConfig().setMaxSizePolicy(MaxSizeConfig.MaxSizePolicy.valueOf((String)cluster.getMaxSizePolicy())).setSize(cluster.getMaxHeapSizePercentage()));
            HashMap<String, MapConfig> mapConfigs = new HashMap<String, MapConfig>();
            mapConfigs.put(this.casProperties.getTicket().getRegistry().getHazelcast().getMapName(), mapConfig);
            config.setMapConfigs(mapConfigs).setNetworkConfig(networkConfig);
        }
        return config.setInstanceName(cluster.getInstanceName()).setProperty("hazelcast.logging.type", cluster.getLoggingType()).setProperty("hazelcast.max.no.heartbeat.seconds", String.valueOf(cluster.getMaxNoHeartbeatSeconds()));
    }
}

