/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket.registry.config;

import com.google.common.collect.Lists;
import com.hazelcast.config.Config;
import com.hazelcast.config.EvictionPolicy;
import com.hazelcast.config.MapConfig;
import com.hazelcast.core.HazelcastInstance;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasPersonDirectoryAttributeRepositoryConfiguration;
import org.apereo.cas.config.HazelcastInstanceConfiguration;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.annotation.DirtiesContext;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit4.SpringRunner;

@RunWith(value=SpringRunner.class)
@SpringBootTest(classes={HazelcastInstanceConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreUtilConfiguration.class, CasPersonDirectoryAttributeRepositoryConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreServicesConfiguration.class, CasCoreLogoutConfiguration.class})
@ContextConfiguration(locations={"classpath:HazelcastInstanceConfigurationTests-config.xml"})
@TestPropertySource(properties={"cas.ticket.registry.hazelcast.configLocation="})
@DirtiesContext
public class DefaultHazelcastInstanceConfigurationTests {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultHazelcastInstanceConfigurationTests.class);
    @Autowired
    @Qualifier(value="hazelcast")
    private HazelcastInstance hzInstance;

    public HazelcastInstance getHzInstance() {
        return this.hzInstance;
    }

    @Test
    public void correctHazelcastInstanceIsCreated() throws Exception {
        Assert.assertNotNull((Object)this.hzInstance);
        Config config = this.hzInstance.getConfig();
        Assert.assertFalse((boolean)config.getNetworkConfig().getJoin().getMulticastConfig().isEnabled());
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"localhost"}), (Object)config.getNetworkConfig().getJoin().getTcpIpConfig().getMembers());
        Assert.assertTrue((boolean)config.getNetworkConfig().isPortAutoIncrement());
        Assert.assertEquals((long)5701L, (long)config.getNetworkConfig().getPort());
        MapConfig mapConfig = config.getMapConfig("tickets");
        Assert.assertNotNull((Object)mapConfig);
        Assert.assertEquals((long)28800L, (long)mapConfig.getMaxIdleSeconds());
        Assert.assertEquals((Object)EvictionPolicy.LRU, (Object)mapConfig.getEvictionPolicy());
        Assert.assertEquals((long)10L, (long)mapConfig.getEvictionPercentage());
    }

    @After
    public void shutdownHz() {
        LOGGER.info("Shutting down hazelcast instance {}", (Object)this.hzInstance.getConfig().getInstanceName());
        this.hzInstance.shutdown();
        while (this.hzInstance.getLifecycleService().isRunning()) {
            LOGGER.info("Waiting for instances to shut down");
        }
    }
}

