/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow.account;

import lombok.Generated;
import org.apereo.cas.config.CasWebflowAccountProfileConfiguration;
import org.apereo.cas.gauth.BaseGoogleAuthenticatorTests;
import org.apereo.cas.web.flow.BaseWebflowConfigurerTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.ViewState;

@Tag(value="WebflowMfaConfig")
@Import(value={BaseGoogleAuthenticatorTests.SharedTestConfiguration.class, CasWebflowAccountProfileConfiguration.class})
@TestPropertySource(properties={"CasFeatureModule.AccountManagement.enabled=true"})
public class GoogleMultifactorAuthenticationAccountProfileWebflowConfigurerTests
extends BaseWebflowConfigurerTests {
    @Autowired
    @Qualifier(value="accountProfileFlowRegistry")
    protected FlowDefinitionRegistry accountFlowDefinitionRegistry;

    @Test
    void verifyOperation() throws Throwable {
        Flow flow = (Flow)this.accountFlowDefinitionRegistry.getFlowDefinition("account");
        ViewState accountView = (ViewState)flow.getState("myAccountProfile");
        Assertions.assertEquals((int)4, (int)accountView.getRenderActionList().size());
        Assertions.assertTrue((boolean)accountView.getRenderActionList().get(0).toString().contains("prepareAccountProfileViewAction"));
        Assertions.assertNotNull((Object)flow.getState("viewRegistration"));
        Assertions.assertNotNull((Object)flow.getState("saveRegistration"));
        Assertions.assertNotNull((Object)flow.getState("googleAccountProfileRegistrationFinalized"));
    }

    @Generated
    public FlowDefinitionRegistry getAccountFlowDefinitionRegistry() {
        return this.accountFlowDefinitionRegistry;
    }
}

