/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow;

import java.util.List;
import java.util.UUID;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.config.CasWebflowAccountProfileConfiguration;
import org.apereo.cas.gauth.BaseGoogleAuthenticatorTests;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccount;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.MockRequestContext;
import org.apereo.cas.web.flow.actions.MultifactorAuthenticationDeviceProviderAction;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.webflow.execution.RequestContext;

@SpringBootTest(classes={BaseGoogleAuthenticatorTests.SharedTestConfiguration.class, CasWebflowAccountProfileConfiguration.class}, properties={"CasFeatureModule.AccountManagement.enabled=true"})
@Tag(value="WebflowMfaActions")
class GoogleAuthenticatorAuthenticationDeviceProviderActionTests {
    @Autowired
    @Qualifier(value="googleAccountDeviceProviderAction")
    private MultifactorAuthenticationDeviceProviderAction googleAccountDeviceProviderAction;
    @Autowired
    @Qualifier(value="googleAuthenticatorAccountRegistry")
    private OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry;

    GoogleAuthenticatorAuthenticationDeviceProviderActionTests() {
    }

    @Test
    void verifyOperation() throws Throwable {
        GoogleAuthenticatorAccount acct = ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().username(UUID.randomUUID().toString())).name(UUID.randomUUID().toString())).secretKey("secret")).validationCode(123456)).scratchCodes(List.of())).build();
        this.googleAuthenticatorAccountRegistry.save((OneTimeTokenAccount)acct);
        MockRequestContext context = MockRequestContext.create();
        WebUtils.putAuthentication((Authentication)RegisteredServiceTestUtils.getAuthentication((String)acct.getUsername()), (RequestContext)context);
        Assertions.assertNull((Object)this.googleAccountDeviceProviderAction.execute((RequestContext)context));
        Assertions.assertEquals((int)1, (int)WebUtils.getMultifactorAuthenticationRegisteredDevices((RequestContext)context).size());
    }
}

