/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow;

import java.util.List;
import java.util.UUID;
import javax.security.auth.login.FailedLoginException;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.authentication.mfa.TestMultifactorAuthenticationProvider;
import org.apereo.cas.gauth.BaseGoogleAuthenticatorTests;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccount;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.services.RegisteredServiceTestUtils;
import org.apereo.cas.util.MockRequestContext;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;

@Tag(value="WebflowMfaActions")
@SpringBootTest(classes={TestMultifactorTestConfiguration.class, BaseGoogleAuthenticatorTests.SharedTestConfiguration.class})
class GoogleAuthenticatorValidateTokenActionTests {
    @Autowired
    @Qualifier(value="googleValidateTokenAction")
    private Action action;
    @Autowired
    @Qualifier(value="googleAuthenticatorAccountRegistry")
    private OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry;
    @Autowired
    @Qualifier(value="dummyProvider")
    private MultifactorAuthenticationProvider dummyProvider;
    @Autowired
    private ConfigurableApplicationContext applicationContext;

    GoogleAuthenticatorValidateTokenActionTests() {
    }

    @Test
    void verifySuccessfulValidation() throws Throwable {
        MockRequestContext context = MockRequestContext.create((ApplicationContext)this.applicationContext);
        GoogleAuthenticatorAccount acct = ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().username(UUID.randomUUID().toString())).name(UUID.randomUUID().toString())).secretKey("secret")).validationCode(123456)).scratchCodes(List.of(Integer.valueOf(666777)))).build();
        this.googleAuthenticatorAccountRegistry.save((OneTimeTokenAccount)acct);
        WebUtils.putAuthentication((Authentication)RegisteredServiceTestUtils.getAuthentication((String)acct.getUsername()), (RequestContext)context);
        WebUtils.putMultifactorAuthenticationProvider((RequestContext)context, (MultifactorAuthenticationProvider)this.dummyProvider);
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.action.execute((RequestContext)context));
        context.setParameter("token", "111222");
        context.setParameter("accountId", String.valueOf(acct.getId()));
        Assertions.assertThrows(FailedLoginException.class, () -> this.action.execute((RequestContext)context));
        context.setParameter("token", ((Number)acct.getScratchCodes().getFirst()).toString());
        Assertions.assertEquals((Object)"success", (Object)this.action.execute((RequestContext)context).getId());
    }

    @TestConfiguration(value="TestMultifactorTestConfiguration", proxyBeanMethods=false)
    static class TestMultifactorTestConfiguration {
        TestMultifactorTestConfiguration() {
        }

        @Bean
        public MultifactorAuthenticationProvider dummyProvider() {
            return new TestMultifactorAuthenticationProvider();
        }
    }
}

