/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow;

import java.util.List;
import java.util.UUID;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredential;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorValidateSelectedRegistrationAction;
import org.apereo.cas.util.MockRequestContext;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.webflow.execution.RequestContext;

@Tag(value="WebflowMfaActions")
class GoogleAuthenticatorValidateSelectedRegistrationActionTests {
    GoogleAuthenticatorValidateSelectedRegistrationActionTests() {
    }

    @Test
    void verifyOperation() throws Throwable {
        MockRequestContext context = MockRequestContext.create();
        GoogleAuthenticatorValidateSelectedRegistrationAction action = new GoogleAuthenticatorValidateSelectedRegistrationAction();
        Assertions.assertEquals((Object)"error", (Object)action.execute((RequestContext)context).getId());
        OneTimeTokenAccount acct = OneTimeTokenAccount.builder().username(UUID.randomUUID().toString()).name(UUID.randomUUID().toString()).secretKey("secret").validationCode(123456).scratchCodes(List.of()).build();
        WebUtils.putOneTimeTokenAccount((RequestContext)context, (OneTimeTokenAccount)acct);
        Assertions.assertEquals((Object)"error", (Object)action.execute((RequestContext)context).getId());
        WebUtils.putCredential((RequestContext)context, (Credential)new GoogleAuthenticatorTokenCredential("token", Long.valueOf(987655L)));
        Assertions.assertEquals((Object)"error", (Object)action.execute((RequestContext)context).getId());
        WebUtils.putCredential((RequestContext)context, (Credential)new GoogleAuthenticatorTokenCredential("token", Long.valueOf(acct.getId())));
        Assertions.assertNull((Object)action.execute((RequestContext)context));
    }
}

