/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow;

import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.util.List;
import java.util.UUID;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.BaseGoogleAuthenticatorTests;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccount;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.util.MockRequestContext;
import org.apereo.cas.util.RandomUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.junit.jupiter.api.parallel.ResourceAccessMode;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpStatus;
import org.springframework.test.context.TestPropertySource;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;

@SpringBootTest(classes={GoogleAuthenticatorSaveRegistrationActionTestConfiguration.class, BaseGoogleAuthenticatorTests.SharedTestConfiguration.class})
@Tag(value="WebflowMfaActions")
@Execution(value=ExecutionMode.SAME_THREAD)
@ResourceLock(value="googleAuthenticatorAccountRegistry", mode=ResourceAccessMode.READ_WRITE)
class GoogleAuthenticatorSaveRegistrationActionTests {
    @Autowired
    @Qualifier(value="googleSaveAccountRegistrationAction")
    private Action googleSaveAccountRegistrationAction;
    @Autowired
    @Qualifier(value="googleAuthenticatorAccountRegistry")
    private OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry;

    GoogleAuthenticatorSaveRegistrationActionTests() {
    }

    @TestConfiguration(value="GoogleAuthenticatorSaveRegistrationActionTests", proxyBeanMethods=false)
    static class GoogleAuthenticatorSaveRegistrationActionTestConfiguration {
        GoogleAuthenticatorSaveRegistrationActionTestConfiguration() {
        }

        @Bean
        public IGoogleAuthenticator googleAuthenticatorInstance() {
            IGoogleAuthenticator auth = (IGoogleAuthenticator)Mockito.mock(IGoogleAuthenticator.class);
            Mockito.when((Object)auth.authorize(Mockito.anyString(), ArgumentMatchers.eq((int)123456))).thenReturn((Object)Boolean.TRUE);
            Mockito.when((Object)auth.authorize(Mockito.anyString(), ArgumentMatchers.eq((int)987654))).thenReturn((Object)Boolean.FALSE);
            Mockito.when((Object)auth.authorize(Mockito.anyString(), ArgumentMatchers.eq((int)112233))).thenThrow(new Throwable[]{new IllegalArgumentException()});
            return auth;
        }
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.mfa.gauth.core.multiple-device-registration-enabled=true"})
    class DefaultTests {
        DefaultTests() {
        }

        @Test
        void verifyAccountValidationFails() throws Throwable {
            GoogleAuthenticatorAccount acct = ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().username(UUID.randomUUID().toString())).name(UUID.randomUUID().toString())).secretKey("secret")).validationCode(123456)).scratchCodes(List.of())).id(RandomUtils.nextLong())).build();
            MockRequestContext context = MockRequestContext.create();
            context.setParameter("token", "918273");
            context.setParameter("accountName", acct.getName());
            context.getFlowScope().put("key", (Object)acct);
            Assertions.assertEquals((Object)"error", (Object)GoogleAuthenticatorSaveRegistrationActionTests.this.googleSaveAccountRegistrationAction.execute((RequestContext)context).getId());
        }

        @Test
        void verifyAccountValidationOnly() throws Throwable {
            GoogleAuthenticatorAccount acct = ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().username(UUID.randomUUID().toString())).name(UUID.randomUUID().toString())).secretKey("secret")).validationCode(123456)).scratchCodes(List.of())).id(RandomUtils.nextLong())).build();
            MockRequestContext context = MockRequestContext.create();
            context.setParameter("token", String.valueOf(acct.getValidationCode()));
            context.setParameter("accountName", acct.getName());
            context.setParameter("validate", "true");
            context.getFlowScope().put("key", (Object)acct);
            Assertions.assertEquals((Object)"success", (Object)GoogleAuthenticatorSaveRegistrationActionTests.this.googleSaveAccountRegistrationAction.execute((RequestContext)context).getId());
            context = MockRequestContext.create();
            context.setParameter("token", "987654");
            Assertions.assertEquals((Object)"error", (Object)GoogleAuthenticatorSaveRegistrationActionTests.this.googleSaveAccountRegistrationAction.execute((RequestContext)context).getId());
            Assertions.assertEquals((int)HttpStatus.UNAUTHORIZED.value(), (int)context.getHttpServletResponse().getStatus());
            context = MockRequestContext.create();
            context.setParameter("token", "112233");
            Assertions.assertEquals((Object)"error", (Object)GoogleAuthenticatorSaveRegistrationActionTests.this.googleSaveAccountRegistrationAction.execute((RequestContext)context).getId());
            Assertions.assertEquals((int)HttpStatus.UNAUTHORIZED.value(), (int)context.getHttpServletResponse().getStatus());
        }
    }

    @Nested
    @TestPropertySource(properties={"cas.authn.mfa.gauth.core.multiple-device-registration-enabled=false"})
    class MultipleRegistrationTests {
        MultipleRegistrationTests() {
        }

        @Test
        void verifyMultipleRegDisabled() throws Exception {
            MockRequestContext context = MockRequestContext.create();
            GoogleAuthenticatorAccount acct = ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().username(UUID.randomUUID().toString())).name(UUID.randomUUID().toString())).secretKey("secret")).validationCode(123456)).scratchCodes(List.of())).id(RandomUtils.nextLong())).build();
            GoogleAuthenticatorSaveRegistrationActionTests.this.googleAuthenticatorAccountRegistry.save((OneTimeTokenAccount)acct);
            context.getFlowScope().put("key", (Object)acct);
            Assertions.assertEquals((Object)"error", (Object)GoogleAuthenticatorSaveRegistrationActionTests.this.googleSaveAccountRegistrationAction.execute((RequestContext)context).getId());
        }
    }
}

