/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.configuration.model.support.mfa.gauth.GoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.gauth.BaseGoogleAuthenticatorTests;
import org.apereo.cas.gauth.credential.RestGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.MockWebServer;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.serialization.JacksonObjectMapperFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.HttpStatus;

@SpringBootTest(classes={BaseGoogleAuthenticatorTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.gauth.rest.url=http://example.com"})
@Tag(value="MFAProvider")
class RestGoogleAuthenticatorTokenCredentialRepositoryTests {
    private static final ObjectMapper MAPPER = JacksonObjectMapperFactory.builder().defaultTypingEnabled(true).build().toObjectMapper();
    @Autowired
    @Qualifier(value="googleAuthenticatorInstance")
    private IGoogleAuthenticator googleAuthenticatorInstance;

    RestGoogleAuthenticatorTokenCredentialRepositoryTests() {
    }

    @Test
    void verifyFailOps() throws Throwable {
        String entity = MAPPER.writeValueAsString(List.of("----"));
        try (MockWebServer webServer = new MockWebServer(entity);){
            GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
            props.getRest().setUrl("http://localhost:" + webServer.getPort());
            RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber());
            webServer.start();
            Assertions.assertNull((Object)repo.get("casuser", 1L));
            Assertions.assertNull((Object)repo.get(1L));
            Assertions.assertNull((Object)repo.get("casuser"));
            Assertions.assertEquals((long)0L, (long)repo.count());
            Assertions.assertEquals((long)0L, (long)repo.count("casuser"));
            Assertions.assertNull((Object)repo.update(null));
        }
    }

    @Test
    void verifyLoad() throws Throwable {
        try (MockWebServer webServer = new MockWebServer();){
            GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
            props.getRest().setUrl("http://localhost:" + webServer.getPort());
            RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber());
            OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
            String entity = MAPPER.writeValueAsString((Object)CollectionUtils.wrapArrayList((Object[])new OneTimeTokenAccount[]{account}));
            webServer.responseBody(entity);
            webServer.start();
            Assertions.assertFalse((boolean)repo.load().isEmpty());
        }
    }

    @Test
    void verifyDelete() throws Throwable {
        try (MockWebServer webServer = new MockWebServer("1");){
            webServer.start();
            GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
            props.getRest().setUrl("http://localhost:" + webServer.getPort());
            RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber());
            Assertions.assertDoesNotThrow(() -> {
                repo.delete("casuser");
                repo.delete(12345L);
                repo.deleteAll();
            });
        }
    }

    @Test
    void verifyGet() throws Throwable {
        try (MockWebServer webServer = new MockWebServer();){
            GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
            props.getRest().setUrl("http://localhost:" + webServer.getPort());
            RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber());
            OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
            String entity = MAPPER.writeValueAsString((Object)CollectionUtils.wrapList((Object[])new OneTimeTokenAccount[]{account}));
            webServer.responseBody(entity);
            webServer.start();
            Assertions.assertFalse((boolean)repo.get(account.getUsername()).isEmpty());
        }
    }

    @Test
    void verifyGetById() throws Throwable {
        try (MockWebServer webServer = new MockWebServer();){
            GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
            props.getRest().setUrl("http://localhost:" + webServer.getPort());
            RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber());
            OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
            String entity = MAPPER.writeValueAsString((Object)account);
            webServer.responseBody(entity);
            webServer.start();
            Assertions.assertNotNull((Object)repo.get(account.getId()));
        }
    }

    @Test
    void verifyGetByIdAndUser() throws Throwable {
        try (MockWebServer webServer = new MockWebServer();){
            GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
            props.getRest().setUrl("http://localhost:" + webServer.getPort());
            RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber());
            OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
            String entity = MAPPER.writeValueAsString((Object)account);
            webServer.responseBody(entity);
            webServer.start();
            Assertions.assertNotNull((Object)repo.get(account.getUsername(), account.getId()));
        }
    }

    @Test
    void verifyCount() throws Throwable {
        try (MockWebServer webServer = new MockWebServer("1");){
            GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
            props.getRest().setUrl("http://localhost:" + webServer.getPort());
            RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber());
            webServer.start();
            Assertions.assertEquals((long)1L, (long)repo.count());
        }
    }

    @Test
    void verifyCountByUser() throws Throwable {
        try (MockWebServer webServer = new MockWebServer("1");){
            GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
            props.getRest().setUrl("http://localhost:" + webServer.getPort());
            RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber());
            webServer.start();
            Assertions.assertEquals((long)1L, (long)repo.count("casuser"));
        }
    }

    @Test
    void verifySave() throws Throwable {
        try (MockWebServer webServer = new MockWebServer();){
            GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
            props.getRest().setUrl("http://localhost:" + webServer.getPort());
            RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber());
            OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
            String entity = MAPPER.writeValueAsString((Object)account);
            webServer.responseBody(entity);
            webServer.start();
            Assertions.assertDoesNotThrow(() -> {
                OneTimeTokenAccount toSave = OneTimeTokenAccount.builder().username(account.getUsername()).secretKey(account.getSecretKey()).validationCode(0).scratchCodes(List.of()).name(UUID.randomUUID().toString()).build();
                repo.save(toSave);
            });
        }
    }

    @Test
    void verifySaveFail() throws Throwable {
        try (MockWebServer webServer = new MockWebServer(HttpStatus.BAD_REQUEST);){
            GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
            props.getRest().setUrl("http://localhost:" + webServer.getPort());
            RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber());
            OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
            webServer.start();
            Assertions.assertNull((Object)repo.update(account));
        }
    }

    @Generated
    public IGoogleAuthenticator getGoogleAuthenticatorInstance() {
        return this.googleAuthenticatorInstance;
    }
}

