/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.UUID;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredential;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorValidateSelectedRegistrationAction;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.binding.message.DefaultMessageContext;
import org.springframework.context.MessageSource;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

@Tag(value="WebflowMfaActions")
public class GoogleAuthenticatorValidateSelectedRegistrationActionTests {
    @Test
    public void verifyOperation() throws Exception {
        MockRequestContext context = new MockRequestContext();
        DefaultMessageContext messageContext = (DefaultMessageContext)context.getMessageContext();
        messageContext.setMessageSource((MessageSource)Mockito.mock(MessageSource.class));
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        GoogleAuthenticatorValidateSelectedRegistrationAction action = new GoogleAuthenticatorValidateSelectedRegistrationAction();
        Assertions.assertEquals((Object)"error", (Object)action.execute((RequestContext)context).getId());
        OneTimeTokenAccount acct = OneTimeTokenAccount.builder().username("casuser").name(UUID.randomUUID().toString()).secretKey("secret").validationCode(123456).scratchCodes(List.of()).build();
        WebUtils.putOneTimeTokenAccount((RequestContext)context, (OneTimeTokenAccount)acct);
        Assertions.assertEquals((Object)"error", (Object)action.execute((RequestContext)context).getId());
        WebUtils.putCredential((RequestContext)context, (Credential)new GoogleAuthenticatorTokenCredential("token", Long.valueOf(987655L)));
        Assertions.assertEquals((Object)"error", (Object)action.execute((RequestContext)context).getId());
        WebUtils.putCredential((RequestContext)context, (Credential)new GoogleAuthenticatorTokenCredential("token", Long.valueOf(acct.getId())));
        Assertions.assertNull((Object)action.execute((RequestContext)context));
    }
}

