/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow;

import com.warrenstrange.googleauth.IGoogleAuthenticator;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.UUID;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.gauth.BaseGoogleAuthenticatorTests;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccount;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.http.HttpStatus;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

@SpringBootTest(classes={GoogleAuthenticatorSaveRegistrationActionTestConfiguration.class, BaseGoogleAuthenticatorTests.SharedTestConfiguration.class})
@Tag(value="WebflowMfaActions")
public class GoogleAuthenticatorSaveRegistrationActionTests {
    @Autowired
    @Qualifier(value="googleSaveAccountRegistrationAction")
    private Action googleSaveAccountRegistrationAction;
    @Autowired
    @Qualifier(value="googleAuthenticatorAccountRegistry")
    private OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry;

    @BeforeEach
    public void beforeEach() {
        this.googleAuthenticatorAccountRegistry.deleteAll();
    }

    @Test
    public void verifyMultipleRegDisabled(@Autowired CasConfigurationProperties casProperties) throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        GoogleAuthenticatorAccount acct = ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().username("casuser")).name(UUID.randomUUID().toString())).secretKey("secret")).validationCode(123456)).scratchCodes(List.of())).build();
        this.googleAuthenticatorAccountRegistry.save((OneTimeTokenAccount)acct);
        context.getFlowScope().put("key", (Object)acct);
        casProperties.getAuthn().getMfa().getGauth().getCore().setMultipleDeviceRegistrationEnabled(false);
        Assertions.assertEquals((Object)"error", (Object)this.googleSaveAccountRegistrationAction.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyAccountValidationFails() throws Exception {
        GoogleAuthenticatorAccount acct = ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().username("casuser")).name(UUID.randomUUID().toString())).secretKey("secret")).validationCode(123456)).scratchCodes(List.of())).build();
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addParameter("token", "918273");
        request.addParameter("accountName", acct.getName());
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        context.getFlowScope().put("key", (Object)acct);
        Assertions.assertEquals((Object)"error", (Object)this.googleSaveAccountRegistrationAction.execute((RequestContext)context).getId());
    }

    @Test
    public void verifyAccountValidationOnly() throws Exception {
        GoogleAuthenticatorAccount acct = ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().username("casuser")).name(UUID.randomUUID().toString())).secretKey("secret")).validationCode(123456)).scratchCodes(List.of())).build();
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.setParameter("token", "123456");
        request.addParameter("accountName", acct.getName());
        request.addParameter("validate", "true");
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        context.getFlowScope().put("key", (Object)acct);
        request.setParameter("token", "987654");
        Assertions.assertEquals((Object)"error", (Object)this.googleSaveAccountRegistrationAction.execute((RequestContext)context).getId());
        Assertions.assertEquals((int)HttpStatus.UNAUTHORIZED.value(), (int)response.getStatus());
        request.setParameter("token", "112233");
        Assertions.assertEquals((Object)"error", (Object)this.googleSaveAccountRegistrationAction.execute((RequestContext)context).getId());
        Assertions.assertEquals((int)HttpStatus.UNAUTHORIZED.value(), (int)response.getStatus());
        request.setParameter("token", "123456");
        Assertions.assertEquals((Object)"success", (Object)this.googleSaveAccountRegistrationAction.execute((RequestContext)context).getId());
    }

    @TestConfiguration(value="GoogleAuthenticatorSaveRegistrationActionTests", proxyBeanMethods=false)
    public static class GoogleAuthenticatorSaveRegistrationActionTestConfiguration {
        @Bean
        public IGoogleAuthenticator googleAuthenticatorInstance() {
            IGoogleAuthenticator auth = (IGoogleAuthenticator)Mockito.mock(IGoogleAuthenticator.class);
            Mockito.when((Object)auth.authorize(Mockito.anyString(), ArgumentMatchers.eq((int)123456))).thenReturn((Object)Boolean.TRUE);
            Mockito.when((Object)auth.authorize(Mockito.anyString(), ArgumentMatchers.eq((int)987654))).thenReturn((Object)Boolean.FALSE);
            Mockito.when((Object)auth.authorize(Mockito.anyString(), ArgumentMatchers.eq((int)112233))).thenThrow(new Throwable[]{new IllegalArgumentException()});
            return auth;
        }
    }
}

