/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.BaseGoogleAuthenticatorTests;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccount;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccountSerializer;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredentialRepositoryEndpoint;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.web.report.AbstractCasEndpointTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Import;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.test.context.TestPropertySource;

@Import(value={BaseGoogleAuthenticatorTests.SharedTestConfiguration.class})
@TestPropertySource(properties={"management.endpoint.gauthCredentialRepository.enabled=true"})
@Tag(value="MFAProvider")
public class GoogleAuthenticatorTokenCredentialRepositoryEndpointTests
extends AbstractCasEndpointTests {
    @Autowired
    @Qualifier(value="googleAuthenticatorTokenCredentialRepositoryEndpoint")
    private GoogleAuthenticatorTokenCredentialRepositoryEndpoint endpoint;
    @Autowired
    @Qualifier(value="googleAuthenticatorAccountRegistry")
    private OneTimeTokenCredentialRepository registry;

    @Test
    public void verifyOperation() {
        OneTimeTokenAccount acct = this.registry.create(UUID.randomUUID().toString());
        GoogleAuthenticatorAccount toSave = ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().username(acct.getUsername())).secretKey(acct.getSecretKey())).validationCode(acct.getValidationCode())).scratchCodes(acct.getScratchCodes())).name(UUID.randomUUID().toString())).build();
        this.registry.save((OneTimeTokenAccount)toSave);
        Assertions.assertNotNull((Object)this.endpoint.get(acct.getUsername()));
        Assertions.assertFalse((boolean)this.endpoint.load().isEmpty());
        ResponseEntity entity = this.endpoint.exportAccounts();
        Assertions.assertEquals((Object)HttpStatus.OK, (Object)entity.getStatusCode());
        this.endpoint.delete(acct.getUsername());
        Assertions.assertTrue((boolean)this.endpoint.get(acct.getUsername()).isEmpty());
        this.endpoint.deleteAll();
        Assertions.assertTrue((boolean)this.endpoint.load().isEmpty());
    }

    @Test
    public void verifyImportOperation() throws Exception {
        OneTimeTokenAccount acct = this.registry.create(UUID.randomUUID().toString());
        GoogleAuthenticatorAccount toSave = ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().username(acct.getUsername())).secretKey(acct.getSecretKey())).validationCode(acct.getValidationCode())).scratchCodes(acct.getScratchCodes())).name(UUID.randomUUID().toString())).build();
        MockHttpServletRequest request = new MockHttpServletRequest();
        String content = new GoogleAuthenticatorAccountSerializer().toString((Object)toSave);
        request.setContent(content.getBytes(StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)HttpStatus.CREATED, (Object)this.endpoint.importAccount((HttpServletRequest)request));
    }

    @Generated
    public GoogleAuthenticatorTokenCredentialRepositoryEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public OneTimeTokenCredentialRepository getRegistry() {
        return this.registry;
    }
}

