/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.io.File;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.BaseGoogleAuthenticatorTests;
import org.apereo.cas.gauth.credential.BaseOneTimeTokenCredentialRepositoryTests;
import org.apereo.cas.gauth.credential.JsonGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;

@SpringBootTest(classes={BaseGoogleAuthenticatorTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.gauth.json.location=file:${java.io.tmpdir}/repository.json"})
@Tag(value="MFAProvider")
public class JsonGoogleAuthenticatorTokenCredentialRepositoryTests
extends BaseOneTimeTokenCredentialRepositoryTests {
    @Autowired
    @Qualifier(value="googleAuthenticatorAccountRegistry")
    private OneTimeTokenCredentialRepository registry;
    @Autowired
    @Qualifier(value="googleAuthenticatorInstance")
    private IGoogleAuthenticator googleAuthenticatorInstance;

    @Test
    public void verifyFails() throws Exception {
        Resource resource = (Resource)Mockito.mock(Resource.class);
        JsonGoogleAuthenticatorTokenCredentialRepository repo = new JsonGoogleAuthenticatorTokenCredentialRepository(resource, this.googleAuthenticatorInstance, CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber());
        Assertions.assertTrue((boolean)repo.load().isEmpty());
        Assertions.assertNull((Object)repo.update(OneTimeTokenAccount.builder().build()));
        Assertions.assertEquals((long)0L, (long)repo.count());
        Assertions.assertDoesNotThrow(() -> repo.delete("casuser"));
        Mockito.when((Object)resource.getFile()).thenReturn((Object)File.createTempFile("test", ".json"));
        Assertions.assertTrue((boolean)repo.get("casuser").isEmpty());
    }

    @Test
    public void verifyNotExists() {
        JsonGoogleAuthenticatorTokenCredentialRepository repo = new JsonGoogleAuthenticatorTokenCredentialRepository((Resource)new ClassPathResource("acct-bad.json"), this.googleAuthenticatorInstance, CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber());
        Assertions.assertTrue((boolean)repo.get("casuser").isEmpty());
    }

    @Test
    public void verifyNoAccounts() throws Exception {
        File file = File.createTempFile("account", ".json");
        FileUtils.writeStringToFile((File)file, (String)"{}", (Charset)StandardCharsets.UTF_8);
        JsonGoogleAuthenticatorTokenCredentialRepository repo = new JsonGoogleAuthenticatorTokenCredentialRepository((Resource)new FileSystemResource(file), this.googleAuthenticatorInstance, CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber());
        Assertions.assertTrue((boolean)repo.get("casuser").isEmpty());
        repo.deleteAll();
        Assertions.assertTrue((boolean)repo.load().isEmpty());
        OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
        account.setUsername(null);
        Assertions.assertNull((Object)repo.save(account));
        account.setUsername(UUID.randomUUID().toString());
        Assertions.assertNotNull((Object)repo.save(account));
        Assertions.assertEquals((long)1L, (long)repo.count());
        repo.delete(account.getUsername());
        Assertions.assertTrue((boolean)repo.load().isEmpty());
    }

    @Test
    public void verifyBadResource() throws Exception {
        JsonGoogleAuthenticatorTokenCredentialRepository repo = new JsonGoogleAuthenticatorTokenCredentialRepository((Resource)new UrlResource(new URL("https://httpbin.org/get")), this.googleAuthenticatorInstance, CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber());
        Assertions.assertTrue((boolean)repo.get("casuser").isEmpty());
    }

    @Override
    @Generated
    public OneTimeTokenCredentialRepository getRegistry() {
        return this.registry;
    }

    @Generated
    public IGoogleAuthenticator getGoogleAuthenticatorInstance() {
        return this.googleAuthenticatorInstance;
    }
}

