/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import java.util.concurrent.ConcurrentHashMap;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.gauth.credential.BaseOneTimeTokenCredentialRepositoryTests;
import org.apereo.cas.gauth.credential.InMemoryGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenAccountCipherExecutor;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.util.cipher.BaseStringCipherExecutor;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.cipher.JasyptNumberCipherExecutor;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.gen.Base64RandomStringGenerator;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Tag;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@Tag(value="MFAProvider")
public class InMemoryGoogleAuthenticatorTokenCredentialRepositoryTests {

    @SpringBootTest(classes={RefreshAutoConfiguration.class, CasCoreUtilConfiguration.class})
    @Nested
    public class DefaultTests
    extends BaseOneTimeTokenCredentialRepositoryTests {
        private final ConcurrentHashMap<String, OneTimeTokenCredentialRepository> repoMap = new ConcurrentHashMap();

        @Override
        public OneTimeTokenCredentialRepository getRegistry() {
            EncryptionJwtSigningJwtCryptographyProperties crypto = new EncryptionJwtSigningJwtCryptographyProperties();
            crypto.getEncryption().setKeySize(256);
            BaseStringCipherExecutor tokenCredentialCipher = CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, OneTimeTokenAccountCipherExecutor.class);
            String password = new Base64RandomStringGenerator(16L).getNewString();
            JasyptNumberCipherExecutor scratchCodesCipher = new JasyptNumberCipherExecutor(password, "scratchCodesCipher");
            return new InMemoryGoogleAuthenticatorTokenCredentialRepository((CipherExecutor)tokenCredentialCipher, (CipherExecutor)scratchCodesCipher, this.getGoogle());
        }

        @Override
        public OneTimeTokenCredentialRepository getRegistry(String testName) {
            return this.repoMap.computeIfAbsent(testName, name -> this.getRegistry());
        }
    }

    @SpringBootTest(classes={RefreshAutoConfiguration.class, CasCoreUtilConfiguration.class})
    @Nested
    public class ScratchCodesEncryptionTests
    extends BaseOneTimeTokenCredentialRepositoryTests {
        private final ConcurrentHashMap<String, OneTimeTokenCredentialRepository> repoMap = new ConcurrentHashMap();

        @Override
        public OneTimeTokenCredentialRepository getRegistry() {
            return new InMemoryGoogleAuthenticatorTokenCredentialRepository(CipherExecutor.noOpOfStringToString(), CipherExecutor.noOpOfNumberToNumber(), this.getGoogle());
        }

        @Override
        public OneTimeTokenCredentialRepository getRegistry(String testName) {
            return this.repoMap.computeIfAbsent(testName, name -> this.getRegistry());
        }
    }
}

