/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorConfig;
import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.config.CasCoreAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationHandlersConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationMetadataConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPolicyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationPrincipalConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationServiceSelectionStrategyConfiguration;
import org.apereo.cas.config.CasCoreAuthenticationSupportConfiguration;
import org.apereo.cas.config.CasCoreConfiguration;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreMultifactorAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesAuthenticationConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreTicketCatalogConfiguration;
import org.apereo.cas.config.CasCoreTicketIdGeneratorsConfiguration;
import org.apereo.cas.config.CasCoreTicketsConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CasCoreWebConfiguration;
import org.apereo.cas.config.CasPersonDirectoryConfiguration;
import org.apereo.cas.config.support.CasWebApplicationServiceFactoryConfiguration;
import org.apereo.cas.config.support.authentication.GoogleAuthenticatorAuthenticationEventExecutionPlanConfiguration;
import org.apereo.cas.config.support.authentication.GoogleAuthenticatorAuthenticationMultifactorProviderBypassConfiguration;
import org.apereo.cas.logout.config.CasCoreLogoutConfiguration;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.web.config.CasCookieConfiguration;
import org.apereo.cas.web.flow.config.CasCoreWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasMultifactorAuthenticationWebflowConfiguration;
import org.apereo.cas.web.flow.config.CasWebflowContextConfiguration;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.aop.AopAutoConfiguration;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.context.annotation.Import;

public abstract class BaseOneTimeTokenCredentialRepositoryTests {
    public static final String PLAIN_SECRET = "plain_secret";
    private final Map<Pair<String, String>, OneTimeTokenAccount> accountHashMap = new LinkedHashMap<Pair<String, String>, OneTimeTokenAccount>();
    private IGoogleAuthenticator google;
    @Mock
    private CipherExecutor<String, String> cipherExecutor;

    public OneTimeTokenAccount getAccount(String testName, String username) {
        return this.accountHashMap.computeIfAbsent((Pair<String, String>)Pair.of((Object)testName, (Object)username), pair -> this.getRegistry((String)pair.getLeft()).create((String)pair.getRight()));
    }

    @BeforeEach
    public void initialize() {
        GoogleAuthenticatorConfig.GoogleAuthenticatorConfigBuilder bldr = new GoogleAuthenticatorConfig.GoogleAuthenticatorConfigBuilder();
        this.google = new GoogleAuthenticator(bldr.build());
    }

    @AfterEach
    public void afterEach() {
        OneTimeTokenCredentialRepository repo = this.getRegistry("afterEach");
        repo.deleteAll();
    }

    @Test
    public void verifyCreate() {
        String casuser = this.getUsernameUnderTest();
        OneTimeTokenAccount acct = this.getAccount("verifyCreate", casuser);
        Assertions.assertNotNull((Object)acct);
        OneTimeTokenCredentialRepository repo = this.getRegistry("verifyCreate");
        OneTimeTokenAccount toSave = OneTimeTokenAccount.builder().username(acct.getUsername()).secretKey(acct.getSecretKey()).validationCode(acct.getValidationCode()).scratchCodes(acct.getScratchCodes()).name(casuser).build();
        toSave = repo.save(toSave);
        Assertions.assertNotNull((Object)toSave);
        Assertions.assertNotNull((Object)repo.get(toSave.getId()));
        Assertions.assertNotNull((Object)repo.get(toSave.getUsername(), toSave.getId()));
        Assertions.assertEquals((long)1L, (long)repo.count());
        Assertions.assertEquals((long)1L, (long)repo.count(toSave.getUsername()));
        repo.delete(acct.getUsername());
        Assertions.assertTrue((boolean)repo.load().isEmpty());
        Assertions.assertEquals((long)0L, (long)repo.count());
        Assertions.assertEquals((long)0L, (long)repo.count(toSave.getUsername()));
    }

    @Test
    public void verifySaveAndUpdate() {
        String casuser = this.getUsernameUnderTest();
        OneTimeTokenAccount acct = this.getAccount("verifySaveAndUpdate", casuser);
        OneTimeTokenCredentialRepository repo = this.getRegistry("verifySaveAndUpdate");
        OneTimeTokenAccount toSave = OneTimeTokenAccount.builder().username(acct.getUsername()).secretKey(acct.getSecretKey()).validationCode(acct.getValidationCode()).scratchCodes(acct.getScratchCodes()).name(casuser).build();
        repo.save(toSave);
        OneTimeTokenAccount s = (OneTimeTokenAccount)repo.get(acct.getUsername()).iterator().next();
        Assertions.assertNotNull((Object)s, (String)"Account not found");
        Assertions.assertNotNull((Object)s.getRegistrationDate());
        Assertions.assertEquals((int)acct.getValidationCode(), (int)s.getValidationCode());
        Assertions.assertEquals((Object)acct.getSecretKey(), (Object)s.getSecretKey());
        s.setSecretKey("newSecret");
        s.setValidationCode(999666);
        repo.update(s);
        Collection accts = repo.get(casuser);
        s = (OneTimeTokenAccount)accts.iterator().next();
        Assertions.assertEquals((int)999666, (int)s.getValidationCode());
        Assertions.assertEquals((Object)"newSecret", (Object)s.getSecretKey());
        repo.delete(s.getId());
        Assertions.assertNull((Object)repo.get(s.getId()));
    }

    @Test
    public void verifyGet() {
        String casuser = this.getUsernameUnderTest();
        OneTimeTokenCredentialRepository repo = this.getRegistry("verifyGet");
        Collection acct = repo.get(casuser);
        Assertions.assertTrue((boolean)acct.isEmpty());
        OneTimeTokenAccount acct2 = this.getAccount("verifyGet", casuser);
        OneTimeTokenAccount toSave = OneTimeTokenAccount.builder().username(acct2.getUsername()).secretKey(acct2.getSecretKey()).validationCode(acct2.getValidationCode()).scratchCodes(acct2.getScratchCodes()).name(casuser).build();
        repo.save(toSave);
        OneTimeTokenAccount acct3 = (OneTimeTokenAccount)repo.get(casuser).iterator().next();
        Assertions.assertNotNull((Object)acct3, (String)"Account not found");
        Assertions.assertEquals((Object)acct2.getUsername(), (Object)acct3.getUsername());
        Assertions.assertEquals((int)acct2.getValidationCode(), (int)acct3.getValidationCode());
        Assertions.assertEquals((Object)acct2.getSecretKey(), (Object)acct3.getSecretKey());
        Assertions.assertEquals(acct2.getScratchCodes().stream().sorted().map(Number::intValue).collect(Collectors.toList()), acct3.getScratchCodes().stream().sorted().map(Number::intValue).collect(Collectors.toList()));
        repo.delete(acct3.getId());
    }

    @Test
    public void verifyCaseSensitivity() {
        String casuser = this.getUsernameUnderTest().toLowerCase();
        OneTimeTokenAccount acct = this.getAccount("verifyCaseSensitivity", casuser);
        Assertions.assertNotNull((Object)acct);
        OneTimeTokenCredentialRepository repo = this.getRegistry("verifyCaseSensitivity");
        OneTimeTokenAccount toSave = OneTimeTokenAccount.builder().username(acct.getUsername()).secretKey(acct.getSecretKey()).validationCode(acct.getValidationCode()).scratchCodes(acct.getScratchCodes()).name(casuser).build();
        toSave = repo.save(toSave);
        Assertions.assertNotNull((Object)toSave);
        Assertions.assertNotNull((Object)repo.get(toSave.getId()));
        Assertions.assertNotNull((Object)repo.get(toSave.getUsername().toUpperCase(), toSave.getId()));
        Assertions.assertEquals((long)1L, (long)repo.count());
        Assertions.assertEquals((long)1L, (long)repo.count(toSave.getUsername().toUpperCase()));
        repo.delete(acct.getUsername().toUpperCase());
        Assertions.assertTrue((boolean)repo.load().isEmpty());
        Assertions.assertEquals((long)0L, (long)repo.count());
        Assertions.assertEquals((long)0L, (long)repo.count(toSave.getUsername().toUpperCase()));
    }

    @Test
    public void verifyGetWithDecodedSecret() {
        String casuser = this.getUsernameUnderTest();
        Mockito.when((Object)((String)this.cipherExecutor.encode((Object)PLAIN_SECRET))).thenReturn((Object)"abc321");
        Mockito.when((Object)((String)this.cipherExecutor.decode((Object)"abc321"))).thenReturn((Object)PLAIN_SECRET);
        OneTimeTokenCredentialRepository repo = this.getRegistry("verifyGetWithDecodedSecret");
        OneTimeTokenAccount acct = this.getAccount("verifyGetWithDecodedSecret", casuser);
        acct.setSecretKey(PLAIN_SECRET);
        OneTimeTokenAccount toSave = OneTimeTokenAccount.builder().username(acct.getUsername()).secretKey(acct.getSecretKey()).validationCode(acct.getValidationCode()).scratchCodes(acct.getScratchCodes()).name(casuser).build();
        repo.save(toSave);
        acct = (OneTimeTokenAccount)repo.get(casuser).iterator().next();
        Assertions.assertEquals((Object)PLAIN_SECRET, (Object)acct.getSecretKey());
    }

    public OneTimeTokenCredentialRepository getRegistry(String testName) {
        return this.getRegistry();
    }

    public abstract OneTimeTokenCredentialRepository getRegistry();

    protected String getUsernameUnderTest() {
        return UUID.randomUUID().toString();
    }

    @Generated
    public Map<Pair<String, String>, OneTimeTokenAccount> getAccountHashMap() {
        return this.accountHashMap;
    }

    @Generated
    public IGoogleAuthenticator getGoogle() {
        return this.google;
    }

    @Generated
    public CipherExecutor<String, String> getCipherExecutor() {
        return this.cipherExecutor;
    }

    @ImportAutoConfiguration(value={RefreshAutoConfiguration.class, MailSenderAutoConfiguration.class, WebMvcAutoConfiguration.class, AopAutoConfiguration.class})
    @SpringBootConfiguration
    @Import(value={CasCoreWebflowConfiguration.class, CasWebflowContextConfiguration.class, CasCoreMultifactorAuthenticationConfiguration.class, CasMultifactorAuthenticationWebflowConfiguration.class, GoogleAuthenticatorAuthenticationMultifactorProviderBypassConfiguration.class, CasCoreTicketsConfiguration.class, CasCoreTicketIdGeneratorsConfiguration.class, CasCoreTicketCatalogConfiguration.class, CasCoreLogoutConfiguration.class, CasCoreHttpConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreServicesConfiguration.class, CasWebApplicationServiceFactoryConfiguration.class, CasCoreAuthenticationConfiguration.class, CasCoreServicesAuthenticationConfiguration.class, CasCoreAuthenticationMetadataConfiguration.class, CasCoreAuthenticationPolicyConfiguration.class, CasCoreAuthenticationPrincipalConfiguration.class, CasCoreAuthenticationHandlersConfiguration.class, CasCoreAuthenticationSupportConfiguration.class, CasPersonDirectoryConfiguration.class, GoogleAuthenticatorAuthenticationEventExecutionPlanConfiguration.class, CasCookieConfiguration.class, CasCoreConfiguration.class, CasCoreAuthenticationServiceSelectionStrategyConfiguration.class, CasCoreUtilConfiguration.class, RefreshAutoConfiguration.class, CasCoreWebConfiguration.class})
    public static class SharedTestConfiguration {
    }
}

