/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.util.List;
import java.util.UUID;
import javax.security.auth.login.AccountExpiredException;
import javax.security.auth.login.AccountNotFoundException;
import lombok.Generated;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.authentication.OneTimeToken;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.authentication.PreventedException;
import org.apereo.cas.authentication.credential.OneTimeTokenCredential;
import org.apereo.cas.gauth.BaseGoogleAuthenticatorTests;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorAccount;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredential;
import org.apereo.cas.gauth.token.GoogleAuthenticatorToken;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialValidator;
import org.apereo.cas.otp.repository.token.OneTimeTokenRepository;
import org.apereo.cas.util.CollectionUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.context.TestConfiguration;
import org.springframework.context.annotation.Bean;

@SpringBootTest(classes={GoogleAuthenticatorOneTimeTokenCredentialValidatorTestConfiguration.class, BaseGoogleAuthenticatorTests.SharedTestConfiguration.class})
@Tag(value="MFAProvider")
public class GoogleAuthenticatorOneTimeTokenCredentialValidatorTests {
    @Autowired
    @Qualifier(value="googleAuthenticatorOneTimeTokenCredentialValidator")
    private OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> validator;
    @Autowired
    @Qualifier(value="googleAuthenticatorAccountRegistry")
    private OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry;
    @Autowired
    @Qualifier(value="oneTimeTokenAuthenticatorTokenRepository")
    private OneTimeTokenRepository oneTimeTokenAuthenticatorTokenRepository;

    @Test
    public void verifyTokenAuthz() {
        OneTimeTokenAccount acct = OneTimeTokenAccount.builder().username("casuser").name(UUID.randomUUID().toString()).secretKey("secret").validationCode(123456).scratchCodes(List.of()).build();
        Assertions.assertTrue((boolean)this.validator.isTokenAuthorizedFor(123456, acct));
        Assertions.assertFalse((boolean)this.validator.isTokenAuthorizedFor(987654, acct));
    }

    @Test
    public void verifyStore() {
        GoogleAuthenticatorToken token = new GoogleAuthenticatorToken(Integer.valueOf(632435), "casuser");
        Assertions.assertDoesNotThrow(() -> this.validator.store((OneTimeToken)token));
    }

    @Test
    public void verifyAcctValidation() throws Exception {
        GoogleAuthenticatorAccount acct = ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().username("casuser")).name(UUID.randomUUID().toString())).secretKey("secret")).validationCode(123456)).scratchCodes(List.of())).build();
        this.googleAuthenticatorAccountRegistry.save((OneTimeTokenAccount)acct);
        GoogleAuthenticatorTokenCredential cred = new GoogleAuthenticatorTokenCredential("123456", Long.valueOf(acct.getId()));
        Assertions.assertNotNull((Object)this.validator.validate(CoreAuthenticationTestUtils.getAuthentication((String)acct.getUsername()), (OneTimeTokenCredential)cred));
    }

    @Test
    public void verifyAcctValidationScratchCode() throws Exception {
        GoogleAuthenticatorAccount acct = ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().username("casuser")).name(UUID.randomUUID().toString())).secretKey("secret")).validationCode(123456)).scratchCodes(CollectionUtils.wrapList((Object[])new Integer[]{834251}))).build();
        this.googleAuthenticatorAccountRegistry.save((OneTimeTokenAccount)acct);
        GoogleAuthenticatorTokenCredential cred = new GoogleAuthenticatorTokenCredential("834251", Long.valueOf(acct.getId()));
        Assertions.assertNotNull((Object)this.validator.validate(CoreAuthenticationTestUtils.getAuthentication((String)acct.getUsername()), (OneTimeTokenCredential)cred));
        Assertions.assertTrue((boolean)this.googleAuthenticatorAccountRegistry.get(acct.getId()).getScratchCodes().isEmpty());
    }

    @Test
    public void verifyTokenReuse() {
        GoogleAuthenticatorAccount acct = ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().username("casuser")).name(UUID.randomUUID().toString())).secretKey("secret")).validationCode(123456)).scratchCodes(List.of())).build();
        this.googleAuthenticatorAccountRegistry.save((OneTimeTokenAccount)acct);
        OneTimeToken otp1 = new OneTimeToken(Integer.valueOf(556644), "casuser");
        this.oneTimeTokenAuthenticatorTokenRepository.store(otp1);
        Assertions.assertThrows(AccountExpiredException.class, () -> this.validator.validate(CoreAuthenticationTestUtils.getAuthentication((String)"casuser"), (OneTimeTokenCredential)new GoogleAuthenticatorTokenCredential("556644", Long.valueOf(123456L))));
    }

    @Test
    public void verifyBadToken() {
        Assertions.assertThrows(PreventedException.class, () -> this.validator.validate(CoreAuthenticationTestUtils.getAuthentication((String)"casuser"), (OneTimeTokenCredential)new GoogleAuthenticatorTokenCredential("abcdefg", Long.valueOf(123456L))));
        Assertions.assertThrows(AccountNotFoundException.class, () -> this.validator.validate(CoreAuthenticationTestUtils.getAuthentication((String)"unknown-user"), (OneTimeTokenCredential)new GoogleAuthenticatorTokenCredential("112233", Long.valueOf(123456L))));
    }

    @Test
    public void verifyMultipleAccountsWithNoId() {
        for (int i = 0; i < 2; ++i) {
            GoogleAuthenticatorAccount acct = ((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)((GoogleAuthenticatorAccount.GoogleAuthenticatorAccountBuilder)GoogleAuthenticatorAccount.builder().username("casuser")).name(String.format("account-%s", i))).secretKey("secret")).validationCode(123456)).scratchCodes(List.of(Integer.valueOf(222222), Integer.valueOf(333333)))).build();
            this.googleAuthenticatorAccountRegistry.save((OneTimeTokenAccount)acct);
        }
        GoogleAuthenticatorTokenCredential cred = new GoogleAuthenticatorTokenCredential("112233", null);
        Assertions.assertThrows(PreventedException.class, () -> this.validator.validate(CoreAuthenticationTestUtils.getAuthentication((String)"casuser"), (OneTimeTokenCredential)cred));
    }

    @Generated
    public OneTimeTokenCredentialValidator<GoogleAuthenticatorTokenCredential, GoogleAuthenticatorToken> getValidator() {
        return this.validator;
    }

    @Generated
    public OneTimeTokenCredentialRepository getGoogleAuthenticatorAccountRegistry() {
        return this.googleAuthenticatorAccountRegistry;
    }

    @Generated
    public OneTimeTokenRepository getOneTimeTokenAuthenticatorTokenRepository() {
        return this.oneTimeTokenAuthenticatorTokenRepository;
    }

    @TestConfiguration(value="GoogleAuthenticatorOneTimeTokenCredentialValidatorTestConfiguration", proxyBeanMethods=false)
    public static class GoogleAuthenticatorOneTimeTokenCredentialValidatorTestConfiguration {
        @Bean
        public IGoogleAuthenticator googleAuthenticatorInstance() {
            IGoogleAuthenticator auth = (IGoogleAuthenticator)Mockito.mock(IGoogleAuthenticator.class);
            Mockito.when((Object)auth.authorize(Mockito.anyString(), ArgumentMatchers.eq((int)123456))).thenReturn((Object)Boolean.TRUE);
            Mockito.when((Object)auth.authorize(Mockito.anyString(), ArgumentMatchers.eq((int)987654))).thenReturn((Object)Boolean.FALSE);
            Mockito.when((Object)auth.authorize(Mockito.anyString(), ArgumentMatchers.eq((int)112233))).thenThrow(new Throwable[]{new IllegalArgumentException()});
            return auth;
        }
    }
}

