/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorMultifactorTrustedDeviceWebflowConfigurer;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorMultifactorWebflowConfigurer;
import org.apereo.cas.trusted.config.ConditionalOnMultifactorTrustedDevicesEnabled;
import org.apereo.cas.trusted.config.MultifactorAuthnTrustConfiguration;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.FlowBuilder;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
@Configuration(value="GoogleAuthenticatorConfiguration", proxyBeanMethods=false)
public class GoogleAuthenticatorConfiguration {
    private static final int WEBFLOW_CONFIGURER_ORDER = 100;

    @ConditionalOnClass(value={MultifactorAuthnTrustConfiguration.class})
    @ConditionalOnMultifactorTrustedDevicesEnabled(prefix="cas.authn.mfa.gauth.core")
    @Configuration(value="GauthMultifactorTrustConfiguration", proxyBeanMethods=false)
    @DependsOn(value={"googleAuthenticatorMultifactorWebflowConfigurer"})
    public static class GoogleAuthenticatorMultifactorTrustConfiguration {
        @ConditionalOnMissingBean(name={"gauthMultifactorTrustWebflowConfigurer"})
        @Bean
        public CasWebflowConfigurer gauthMultifactorTrustWebflowConfigurer(@Qualifier(value="googleAuthenticatorFlowRegistry") FlowDefinitionRegistry googleAuthenticatorFlowRegistry, ConfigurableApplicationContext applicationContext, CasConfigurationProperties casProperties, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            GoogleAuthenticatorMultifactorTrustedDeviceWebflowConfigurer cfg = new GoogleAuthenticatorMultifactorTrustedDeviceWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, googleAuthenticatorFlowRegistry, applicationContext, casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)applicationContext));
            cfg.setOrder(101);
            return cfg;
        }

        @Bean
        public CasWebflowExecutionPlanConfigurer gauthMultifactorTrustCasWebflowExecutionPlanConfigurer(@Qualifier(value="gauthMultifactorTrustWebflowConfigurer") CasWebflowConfigurer gauthMultifactorTrustWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(gauthMultifactorTrustWebflowConfigurer);
        }
    }

    @Configuration(value="GoogleAuthenticatorMultifactorWebflowConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class GoogleAuthenticatorMultifactorWebflowConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"googleAuthenticatorFlowRegistry"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public FlowDefinitionRegistry googleAuthenticatorFlowRegistry(ConfigurableApplicationContext applicationContext, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices, @Qualifier(value="flowBuilder") FlowBuilder flowBuilder) {
            FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder((ApplicationContext)applicationContext, flowBuilderServices);
            builder.addFlowBuilder(flowBuilder, "mfa-gauth");
            return builder.build();
        }

        @ConditionalOnMissingBean(name={"googleAuthenticatorMultifactorWebflowConfigurer"})
        @Bean
        public CasWebflowConfigurer googleAuthenticatorMultifactorWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="googleAuthenticatorFlowRegistry") FlowDefinitionRegistry googleAuthenticatorFlowRegistry, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
            GoogleAuthenticatorMultifactorWebflowConfigurer cfg = new GoogleAuthenticatorMultifactorWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, googleAuthenticatorFlowRegistry, applicationContext, casProperties, MultifactorAuthenticationWebflowUtils.getMultifactorAuthenticationWebflowCustomizers((ConfigurableApplicationContext)applicationContext));
            cfg.setOrder(100);
            return cfg;
        }

        @Bean
        @ConditionalOnMissingBean(name={"googleCasWebflowExecutionPlanConfigurer"})
        public CasWebflowExecutionPlanConfigurer googleCasWebflowExecutionPlanConfigurer(@Qualifier(value="googleAuthenticatorMultifactorWebflowConfigurer") CasWebflowConfigurer googleAuthenticatorMultifactorWebflowConfigurer) {
            return plan -> plan.registerWebflowConfigurer(googleAuthenticatorMultifactorWebflowConfigurer);
        }
    }
}

