/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.web.flow;

import java.util.List;
import java.util.UUID;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredential;
import org.apereo.cas.gauth.web.flow.GoogleAuthenticatorValidateSelectedRegistrationAction;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.springframework.binding.message.MessageContext;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.core.collection.LocalAttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockFlowExecutionContext;
import org.springframework.webflow.test.MockFlowSession;

@Tag(value="WebflowActions")
public class GoogleAuthenticatorValidateSelectedRegistrationActionTests {
    @Test
    public void verifyOperation() throws Exception {
        RequestContext context = (RequestContext)Mockito.mock(RequestContext.class);
        Mockito.when((Object)context.getConversationScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)context.getFlowScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)context.getRequestScope()).thenReturn((Object)new LocalAttributeMap());
        Mockito.when((Object)context.getMessageContext()).thenReturn((Object)((MessageContext)Mockito.mock(MessageContext.class)));
        Mockito.when((Object)context.getFlowExecutionContext()).thenReturn((Object)new MockFlowExecutionContext((FlowSession)new MockFlowSession(new Flow("mockFlow"))));
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        Mockito.when((Object)context.getExternalContext()).thenReturn((Object)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        RequestContextHolder.setRequestContext((RequestContext)context);
        ExternalContextHolder.setExternalContext((ExternalContext)context.getExternalContext());
        GoogleAuthenticatorValidateSelectedRegistrationAction action = new GoogleAuthenticatorValidateSelectedRegistrationAction();
        Assertions.assertEquals((Object)"error", (Object)action.execute(context).getId());
        OneTimeTokenAccount acct = OneTimeTokenAccount.builder().username("casuser").name(UUID.randomUUID().toString()).secretKey("secret").validationCode(123456).scratchCodes(List.of()).build();
        WebUtils.putOneTimeTokenAccount((RequestContext)context, (OneTimeTokenAccount)acct);
        Assertions.assertEquals((Object)"error", (Object)action.execute(context).getId());
        WebUtils.putCredential((RequestContext)context, (Credential)new GoogleAuthenticatorTokenCredential("token", Long.valueOf(987655L)));
        Assertions.assertEquals((Object)"error", (Object)action.execute(context).getId());
        WebUtils.putCredential((RequestContext)context, (Credential)new GoogleAuthenticatorTokenCredential("token", Long.valueOf(acct.getId())));
        Assertions.assertNull((Object)action.execute(context));
    }
}

