/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import java.util.concurrent.ConcurrentHashMap;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.gauth.credential.BaseOneTimeTokenCredentialRepositoryTests;
import org.apereo.cas.gauth.credential.InMemoryGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.junit.jupiter.api.Tag;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;

@SpringBootTest(classes={RefreshAutoConfiguration.class, CasCoreUtilConfiguration.class})
@Tag(value="MFA")
public class InMemoryGoogleAuthenticatorTokenCredentialRepositoryTests
extends BaseOneTimeTokenCredentialRepositoryTests {
    private final ConcurrentHashMap<String, OneTimeTokenCredentialRepository> repoMap = new ConcurrentHashMap();

    @Override
    public OneTimeTokenCredentialRepository getRegistry() {
        return new InMemoryGoogleAuthenticatorTokenCredentialRepository(CipherExecutor.noOpOfStringToString(), this.getGoogle());
    }

    @Override
    public OneTimeTokenCredentialRepository getRegistry(String testName) {
        return this.repoMap.computeIfAbsent(testName, name -> this.getRegistry());
    }
}

