/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.warrenstrange.googleauth.IGoogleAuthenticator;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.configuration.model.support.mfa.gauth.GoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.gauth.BaseGoogleAuthenticatorTests;
import org.apereo.cas.gauth.credential.RestGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.util.MockWebServer;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.function.Executable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;

@SpringBootTest(classes={BaseGoogleAuthenticatorTests.SharedTestConfiguration.class}, properties={"cas.authn.mfa.gauth.rest.url=http://example.com"})
@Tag(value="MFA")
public class RestGoogleAuthenticatorTokenCredentialRepositoryTests {
    private static final ObjectMapper MAPPER = new ObjectMapper().findAndRegisterModules();
    @Autowired
    @Qualifier(value="googleAuthenticatorInstance")
    private IGoogleAuthenticator googleAuthenticatorInstance;

    @Test
    public void verifyLoad() throws Exception {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8551");
        RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        String entity = MAPPER.writeValueAsString(List.of());
        try (MockWebServer webServer = new MockWebServer(8551, (Resource)new ByteArrayResource(entity.getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.OK);){
            webServer.start();
            Assertions.assertTrue((boolean)repo.load().isEmpty());
        }
    }

    @Test
    public void verifyDelete() throws Exception {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8550");
        final RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        try (MockWebServer webServer = new MockWebServer(8550, (Resource)new ByteArrayResource("1".getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.OK);){
            webServer.start();
            Assertions.assertDoesNotThrow((Executable)new Executable(){

                public void execute() throws Throwable {
                    repo.delete("casuser");
                    repo.deleteAll();
                }
            });
        }
    }

    @Test
    public void verifyGet() throws Exception {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8552");
        RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
        String entity = MAPPER.writeValueAsString((Object)account);
        try (MockWebServer webServer = new MockWebServer(8552, (Resource)new ByteArrayResource(entity.getBytes(StandardCharsets.UTF_8), "Results"), HttpStatus.OK);){
            webServer.start();
            Assertions.assertNotNull((Object)repo.get(account.getUsername()));
        }
    }

    @Test
    public void verifyCount() throws Exception {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8552");
        RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        try (MockWebServer webServer = new MockWebServer(8552, (Resource)new ByteArrayResource("1".getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.OK);){
            webServer.start();
            Assertions.assertEquals((long)1L, (long)repo.count());
        }
    }

    @Test
    public void verifySave() throws Exception {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8553");
        final RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        final OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
        String entity = MAPPER.writeValueAsString((Object)account);
        try (MockWebServer webServer = new MockWebServer(8553, (Resource)new ByteArrayResource(entity.getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.OK);){
            webServer.start();
            Assertions.assertDoesNotThrow((Executable)new Executable(){

                public void execute() throws Throwable {
                    repo.save(account.getUsername(), account.getSecretKey(), 0, List.of());
                }
            });
        }
    }

    @Test
    public void verifySaveFail() throws Exception {
        GoogleAuthenticatorMultifactorProperties props = new GoogleAuthenticatorMultifactorProperties();
        props.getRest().setUrl("http://localhost:8554");
        RestGoogleAuthenticatorTokenCredentialRepository repo = new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance, props, CipherExecutor.noOpOfStringToString());
        OneTimeTokenAccount account = repo.create(UUID.randomUUID().toString());
        try (MockWebServer webServer = new MockWebServer(8554, (Resource)new ByteArrayResource("".getBytes(StandardCharsets.UTF_8), "Output"), HttpStatus.BAD_REQUEST);){
            webServer.start();
            Assertions.assertNull((Object)repo.update(account));
        }
    }

    @Generated
    public IGoogleAuthenticator getGoogleAuthenticatorInstance() {
        return this.googleAuthenticatorInstance;
    }
}

