/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.gauth.credential;

import java.util.UUID;
import lombok.Generated;
import org.apereo.cas.authentication.OneTimeTokenAccount;
import org.apereo.cas.gauth.BaseGoogleAuthenticatorTests;
import org.apereo.cas.gauth.credential.GoogleAuthenticatorTokenCredentialRepositoryEndpoint;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.web.report.AbstractCasEndpointTests;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.TestPropertySource;

@Import(value={BaseGoogleAuthenticatorTests.SharedTestConfiguration.class})
@TestPropertySource(properties={"management.endpoint.gauthCredentialRepository.enabled=true"})
@Tag(value="MFA")
public class GoogleAuthenticatorTokenCredentialRepositoryEndpointTests
extends AbstractCasEndpointTests {
    @Autowired
    @Qualifier(value="googleAuthenticatorTokenCredentialRepositoryEndpoint")
    private GoogleAuthenticatorTokenCredentialRepositoryEndpoint endpoint;
    @Autowired
    @Qualifier(value="googleAuthenticatorAccountRegistry")
    private OneTimeTokenCredentialRepository registry;

    @Test
    public void verifyOperation() {
        OneTimeTokenAccount acct = this.registry.create(UUID.randomUUID().toString());
        this.registry.save(acct.getUsername(), acct.getSecretKey(), acct.getValidationCode(), acct.getScratchCodes());
        Assertions.assertNotNull((Object)this.endpoint.get(acct.getUsername()));
        Assertions.assertFalse((boolean)this.endpoint.load().isEmpty());
        this.endpoint.delete(acct.getUsername());
        Assertions.assertNull((Object)this.endpoint.get(acct.getUsername()));
        this.endpoint.deleteAll();
        Assertions.assertTrue((boolean)this.endpoint.load().isEmpty());
    }

    @Generated
    public GoogleAuthenticatorTokenCredentialRepositoryEndpoint getEndpoint() {
        return this.endpoint;
    }

    @Generated
    public OneTimeTokenCredentialRepository getRegistry() {
        return this.registry;
    }
}

