/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.DefaultChainingMultifactorAuthenticationBypassProvider;
import org.apereo.cas.authentication.bypass.AuthenticationMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.bypass.CredentialMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.bypass.GroovyMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.bypass.HttpRequestMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.bypass.MultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.bypass.PrincipalMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.bypass.RegisteredServiceMultifactorAuthenticationProviderBypass;
import org.apereo.cas.authentication.bypass.RestMultifactorAuthenticationProviderBypass;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.GoogleAuthenticatorMultifactorProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="googleAuthenticatorMultifactorProviderBypassConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class GoogleAuthenticatorAuthenticationMultifactorProviderBypassConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;

    @ConditionalOnMissingBean(name={"googleAuthenticatorBypassEvaluator"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypass googleAuthenticatorBypassEvaluator() {
        DefaultChainingMultifactorAuthenticationBypassProvider bypass = new DefaultChainingMultifactorAuthenticationBypassProvider();
        MultifactorAuthenticationProviderBypassProperties props = this.casProperties.getAuthn().getMfa().getGauth().getBypass();
        if (StringUtils.isNotBlank((CharSequence)props.getPrincipalAttributeName())) {
            bypass.addMultifactorAuthenticationProviderBypass(this.googleAuthenticatorRegisteredServiceMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getAuthenticationAttributeName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationHandlerName()) || StringUtils.isNotBlank((CharSequence)props.getAuthenticationMethodName())) {
            bypass.addMultifactorAuthenticationProviderBypass(this.googleAuthenticatorAuthenticationMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getCredentialClassType())) {
            bypass.addMultifactorAuthenticationProviderBypass(this.googleAuthenticatorCredentialMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getHttpRequestHeaders()) || StringUtils.isNotBlank((CharSequence)props.getHttpRequestRemoteAddress())) {
            bypass.addMultifactorAuthenticationProviderBypass(this.googleAuthenticatorHttpRequestMultifactorAuthenticationProviderBypass());
        }
        if (props.getGroovy().getLocation() != null) {
            bypass.addMultifactorAuthenticationProviderBypass(this.googleAuthenticatorGroovyMultifactorAuthenticationProviderBypass());
        }
        if (StringUtils.isNotBlank((CharSequence)props.getRest().getUrl())) {
            bypass.addMultifactorAuthenticationProviderBypass(this.googleAuthenticatorRestMultifactorAuthenticationProviderBypass());
        }
        return bypass;
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorRestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypass googleAuthenticatorRestMultifactorAuthenticationProviderBypass() {
        GoogleAuthenticatorMultifactorProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new RestMultifactorAuthenticationProviderBypass(props, gauth.getId());
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorGroovyMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypass googleAuthenticatorGroovyMultifactorAuthenticationProviderBypass() {
        GoogleAuthenticatorMultifactorProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new GroovyMultifactorAuthenticationProviderBypass(props, gauth.getId());
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorHttpRequestMultifactorAuthenticationProviderBypass"})
    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypass googleAuthenticatorHttpRequestMultifactorAuthenticationProviderBypass() {
        GoogleAuthenticatorMultifactorProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new HttpRequestMultifactorAuthenticationProviderBypass(props, gauth.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"googleAuthenticatorCredentialMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypass googleAuthenticatorCredentialMultifactorAuthenticationProviderBypass() {
        GoogleAuthenticatorMultifactorProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new CredentialMultifactorAuthenticationProviderBypass(props, gauth.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"googleAuthenticatorRegisteredServiceMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypass googleAuthenticatorRegisteredServiceMultifactorAuthenticationProviderBypass() {
        GoogleAuthenticatorMultifactorProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        return new RegisteredServiceMultifactorAuthenticationProviderBypass(gauth.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"googleAuthenticatorPrincipalMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypass googleAuthenticatorPrincipalMultifactorAuthenticationProviderBypass() {
        GoogleAuthenticatorMultifactorProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new PrincipalMultifactorAuthenticationProviderBypass(props, gauth.getId());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"googleAuthenticatorAuthenticationMultifactorAuthenticationProviderBypass"})
    public MultifactorAuthenticationProviderBypass googleAuthenticatorAuthenticationMultifactorAuthenticationProviderBypass() {
        GoogleAuthenticatorMultifactorProperties gauth = this.casProperties.getAuthn().getMfa().getGauth();
        MultifactorAuthenticationProviderBypassProperties props = gauth.getBypass();
        return new AuthenticationMultifactorAuthenticationProviderBypass(props, gauth.getId());
    }
}

