/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config.support.authentication;

import com.warrenstrange.googleauth.GoogleAuthenticator;
import com.warrenstrange.googleauth.GoogleAuthenticatorConfig;
import com.warrenstrange.googleauth.IGoogleAuthenticator;
import com.warrenstrange.googleauth.KeyRepresentation;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.adaptors.gauth.GoogleAuthenticatorAuthenticationHandler;
import org.apereo.cas.adaptors.gauth.GoogleAuthenticatorMultifactorAuthenticationProvider;
import org.apereo.cas.adaptors.gauth.repository.credentials.InMemoryGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.adaptors.gauth.repository.credentials.JsonGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.adaptors.gauth.repository.credentials.RestGoogleAuthenticatorTokenCredentialRepository;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.metadata.AuthenticationContextAttributeMetaDataPopulator;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProperties;
import org.apereo.cas.otp.repository.credentials.OneTimeTokenCredentialRepository;
import org.apereo.cas.otp.repository.token.OneTimeTokenRepository;
import org.apereo.cas.otp.repository.token.OneTimeTokenRepositoryCleaner;
import org.apereo.cas.otp.web.flow.OneTimeTokenAccountCheckRegistrationAction;
import org.apereo.cas.otp.web.flow.OneTimeTokenAccountSaveRegistrationAction;
import org.apereo.cas.services.DefaultMultifactorAuthenticationProviderBypass;
import org.apereo.cas.services.MultifactorAuthenticationProvider;
import org.apereo.cas.services.MultifactorAuthenticationProviderBypass;
import org.apereo.cas.services.ServicesManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.client.RestTemplate;
import org.springframework.webflow.execution.Action;

@Configuration(value="googleAuthenticatorAuthenticationEventExecutionPlanConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class GoogleAuthenticatorAuthenticationEventExecutionPlanConfiguration
implements AuthenticationEventExecutionPlanConfigurer {
    @Lazy
    @Autowired
    @Qualifier(value="googleAuthenticatorAccountRegistry")
    private OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry;
    @Lazy
    @Autowired
    @Qualifier(value="oneTimeTokenAuthenticatorTokenRepository")
    private OneTimeTokenRepository oneTimeTokenAuthenticatorTokenRepository;
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;

    @Bean
    public IGoogleAuthenticator googleAuthenticatorInstance() {
        MultifactorAuthenticationProperties.GAuth gauth = this.casProperties.getAuthn().getMfa().getGauth();
        GoogleAuthenticatorConfig.GoogleAuthenticatorConfigBuilder bldr = new GoogleAuthenticatorConfig.GoogleAuthenticatorConfigBuilder();
        bldr.setCodeDigits(gauth.getCodeDigits());
        bldr.setTimeStepSizeInMillis(TimeUnit.SECONDS.toMillis(gauth.getTimeStepSize()));
        bldr.setWindowSize(gauth.getWindowSize());
        bldr.setKeyRepresentation(KeyRepresentation.BASE32);
        return new GoogleAuthenticator(bldr.build());
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorAuthenticationHandler"})
    @Bean
    @RefreshScope
    public AuthenticationHandler googleAuthenticatorAuthenticationHandler() {
        return new GoogleAuthenticatorAuthenticationHandler(this.casProperties.getAuthn().getMfa().getGauth().getName(), this.servicesManager, this.googlePrincipalFactory(), this.googleAuthenticatorInstance(), this.oneTimeTokenAuthenticatorTokenRepository, this.googleAuthenticatorAccountRegistry);
    }

    @Bean
    @RefreshScope
    public MultifactorAuthenticationProviderBypass googleBypassEvaluator() {
        return new DefaultMultifactorAuthenticationProviderBypass(this.casProperties.getAuthn().getMfa().getGauth().getBypass());
    }

    @Bean
    @RefreshScope
    public MultifactorAuthenticationProvider googleAuthenticatorAuthenticationProvider() {
        MultifactorAuthenticationProperties.GAuth gauth = this.casProperties.getAuthn().getMfa().getGauth();
        GoogleAuthenticatorMultifactorAuthenticationProvider p = new GoogleAuthenticatorMultifactorAuthenticationProvider();
        p.setBypassEvaluator(this.googleBypassEvaluator());
        p.setGlobalFailureMode(this.casProperties.getAuthn().getMfa().getGlobalFailureMode());
        p.setOrder(gauth.getRank());
        p.setId(gauth.getId());
        return p;
    }

    @Bean
    @RefreshScope
    public AuthenticationMetaDataPopulator googleAuthenticatorAuthenticationMetaDataPopulator() {
        return new AuthenticationContextAttributeMetaDataPopulator(this.casProperties.getAuthn().getMfa().getAuthenticationContextAttribute(), this.googleAuthenticatorAuthenticationHandler(), this.googleAuthenticatorAuthenticationProvider());
    }

    @Bean
    @RefreshScope
    public Action googleAccountRegistrationAction() {
        MultifactorAuthenticationProperties.GAuth gauth = this.casProperties.getAuthn().getMfa().getGauth();
        return new OneTimeTokenAccountCheckRegistrationAction(this.googleAuthenticatorAccountRegistry, gauth.getLabel(), gauth.getIssuer());
    }

    @ConditionalOnProperty(prefix="cas.authn.mfa.gauth.cleaner", name={"enabled"}, havingValue="true", matchIfMissing=true)
    @Bean
    @Autowired
    public OneTimeTokenRepositoryCleaner googleAuthenticatorTokenRepositoryCleaner(@Qualifier(value="oneTimeTokenAuthenticatorTokenRepository") OneTimeTokenRepository oneTimeTokenAuthenticatorTokenRepository) {
        return new GoogleAuthenticatorOneTimeTokenRepositoryCleaner(oneTimeTokenAuthenticatorTokenRepository);
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorAccountRegistry"})
    @Bean
    @RefreshScope
    public OneTimeTokenCredentialRepository googleAuthenticatorAccountRegistry() {
        MultifactorAuthenticationProperties.GAuth gauth = this.casProperties.getAuthn().getMfa().getGauth();
        if (gauth.getJson().getConfig().getLocation() != null) {
            return new JsonGoogleAuthenticatorTokenCredentialRepository(gauth.getJson().getConfig().getLocation(), this.googleAuthenticatorInstance());
        }
        if (StringUtils.isNotBlank((CharSequence)gauth.getRest().getEndpointUrl())) {
            return new RestGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance(), new RestTemplate(), gauth);
        }
        return new InMemoryGoogleAuthenticatorTokenCredentialRepository(this.googleAuthenticatorInstance());
    }

    @Bean
    @RefreshScope
    public Action googleSaveAccountRegistrationAction() {
        return new OneTimeTokenAccountSaveRegistrationAction(this.googleAuthenticatorAccountRegistry);
    }

    @ConditionalOnMissingBean(name={"googlePrincipalFactory"})
    @Bean
    public PrincipalFactory googlePrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    public void configureAuthenticationExecutionPlan(AuthenticationEventExecutionPlan plan) {
        if (StringUtils.isNotBlank((CharSequence)this.casProperties.getAuthn().getMfa().getGauth().getIssuer())) {
            plan.registerAuthenticationHandler(this.googleAuthenticatorAuthenticationHandler());
            plan.registerMetadataPopulator(this.googleAuthenticatorAuthenticationMetaDataPopulator());
        }
    }

    public class GoogleAuthenticatorOneTimeTokenRepositoryCleaner
    extends OneTimeTokenRepositoryCleaner {
        public GoogleAuthenticatorOneTimeTokenRepositoryCleaner(OneTimeTokenRepository tokenRepository) {
            super(tokenRepository);
        }

        @Scheduled(initialDelayString="${cas.authn.mfa.gauth.cleaner.startDelay:PT30S}", fixedDelayString="${cas.authn.mfa.gauth.cleaner.repeatInterval:PT35S}")
        public void clean() {
            super.clean();
        }
    }
}

