/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.adaptors.gauth.web.flow.GoogleAuthenticatorMultifactorTrustWebflowConfigurer;
import org.apereo.cas.adaptors.gauth.web.flow.GoogleAuthenticatorMultifactorWebflowConfigurer;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.trusted.authentication.api.MultifactorAuthenticationTrustStorage;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.webflow.config.FlowDefinitionRegistryBuilder;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;

@Configuration(value="googleAuthenticatorConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
public class GoogleAuthenticatorConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired
    private FlowBuilderServices flowBuilderServices;

    @Bean
    public FlowDefinitionRegistry googleAuthenticatorFlowRegistry() {
        FlowDefinitionRegistryBuilder builder = new FlowDefinitionRegistryBuilder(this.applicationContext, this.flowBuilderServices);
        builder.setBasePath("classpath*:/webflow");
        builder.addFlowLocationPattern("/mfa-gauth/*-webflow.xml");
        return builder.build();
    }

    @ConditionalOnMissingBean(name={"googleAuthenticatorMultifactorWebflowConfigurer"})
    @Bean
    public CasWebflowConfigurer googleAuthenticatorMultifactorWebflowConfigurer() {
        return new GoogleAuthenticatorMultifactorWebflowConfigurer(this.flowBuilderServices, this.loginFlowDefinitionRegistry, this.googleAuthenticatorFlowRegistry());
    }

    @ConditionalOnClass(value={MultifactorAuthenticationTrustStorage.class})
    @ConditionalOnProperty(prefix="cas.authn.mfa.gauth", name={"trustedDeviceEnabled"}, havingValue="true", matchIfMissing=true)
    @Configuration(value="gauthMultifactorTrustConfiguration")
    public class GoogleAuthenticatorMultifactorTrustConfiguration {
        @ConditionalOnMissingBean(name={"gauthMultifactorTrustWebflowConfigurer"})
        @Bean
        public CasWebflowConfigurer gauthMultifactorTrustWebflowConfigurer() {
            return new GoogleAuthenticatorMultifactorTrustWebflowConfigurer(GoogleAuthenticatorConfiguration.this.flowBuilderServices, GoogleAuthenticatorConfiguration.this.loginFlowDefinitionRegistry, GoogleAuthenticatorConfiguration.this.casProperties.getAuthn().getMfa().getTrusted().isDeviceRegistrationEnabled(), GoogleAuthenticatorConfiguration.this.googleAuthenticatorFlowRegistry());
        }
    }
}

