/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.digest.web.flow;

import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.digest.DigestCredential;
import org.apereo.cas.digest.DigestHashedCredentialRetriever;
import org.apereo.cas.digest.util.DigestAuthenticationUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.flow.actions.AbstractNonInteractiveCredentialsAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.http.credentials.DigestCredentials;
import org.pac4j.http.credentials.extractor.DigestAuthExtractor;
import org.pac4j.jee.context.JEEContext;
import org.pac4j.jee.context.session.JEESessionStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class DigestAuthenticationAction
extends AbstractNonInteractiveCredentialsAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DigestAuthenticationAction.class);
    private final String nonce = DigestAuthenticationUtils.createNonce();
    private final DigestHashedCredentialRetriever credentialRetriever;
    private final String realm;
    private final String authenticationMethod;

    public DigestAuthenticationAction(CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, String realm, String authenticationMethod, DigestHashedCredentialRetriever credentialRetriever) {
        super(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy);
        this.realm = realm;
        this.authenticationMethod = authenticationMethod;
        this.credentialRetriever = credentialRetriever;
    }

    protected Credential constructCredentialsFromRequest(RequestContext requestContext) {
        try {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
            DigestAuthExtractor extractor = new DigestAuthExtractor();
            JEEContext webContext = new JEEContext(request, response);
            Optional credentialsResult = extractor.extract((WebContext)webContext, (SessionStore)JEESessionStore.INSTANCE);
            if (credentialsResult.isEmpty()) {
                response.addHeader("WWW-Authenticate", DigestAuthenticationUtils.createAuthenticateHeader(this.realm, this.authenticationMethod, this.nonce));
                response.setStatus(401);
                return null;
            }
            DigestCredentials credentials = (DigestCredentials)credentialsResult.get();
            LOGGER.debug("Received digest authentication request from credentials [{}] ", (Object)credentials);
            String credential = this.credentialRetriever.findCredential(credentials.getUsername(), this.realm);
            LOGGER.trace("Digest credential password on record for [{}] is [{}]", (Object)credentials.getUsername(), (Object)credential);
            String serverResponse = credentials.calculateServerDigest(true, credential);
            LOGGER.trace("Server digest calculated for [{}] is [{}]", (Object)credentials.getUsername(), (Object)serverResponse);
            String clientResponse = credentials.getToken();
            if (!serverResponse.equals(clientResponse)) {
                LOGGER.trace("Server digest [{}] does not mach [{}]", (Object)serverResponse, (Object)clientResponse);
                response.setStatus(401);
                return null;
            }
            return new DigestCredential(credentials.getUsername(), this.realm, credentials.getToken());
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return null;
        }
    }
}

