/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.digest.config;

import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.digest.DigestProperties;
import org.apereo.cas.digest.DefaultDigestHashedCredentialRetriever;
import org.apereo.cas.digest.DigestHashedCredentialRetriever;
import org.apereo.cas.digest.web.flow.DigestAuthenticationAction;
import org.apereo.cas.digest.web.flow.DigestAuthenticationWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.apereo.cas.web.flow.CasWebflowExecutionPlanConfigurer;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;
import org.springframework.webflow.execution.Action;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@Configuration(value="digestAuthenticationConfiguration", proxyBeanMethods=false)
public class DigestAuthenticationConfiguration {
    @ConditionalOnMissingBean(name={"digestAuthenticationWebflowConfigurer"})
    @Bean
    public CasWebflowConfigurer digestAuthenticationWebflowConfigurer(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="loginFlowRegistry") FlowDefinitionRegistry loginFlowDefinitionRegistry, @Qualifier(value="flowBuilderServices") FlowBuilderServices flowBuilderServices) {
        return new DigestAuthenticationWebflowConfigurer(flowBuilderServices, loginFlowDefinitionRegistry, applicationContext, casProperties);
    }

    @Bean
    @ConditionalOnMissingBean(name={"digestAuthenticationAction"})
    public Action digestAuthenticationAction(@Qualifier(value="defaultDigestCredentialRetriever") DigestHashedCredentialRetriever defaultDigestCredentialRetriever, CasConfigurationProperties casProperties, @Qualifier(value="adaptiveAuthenticationPolicy") AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, @Qualifier(value="serviceTicketRequestWebflowEventResolver") CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, @Qualifier(value="initialAuthenticationAttemptWebflowEventResolver") CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver) {
        return new DigestAuthenticationAction(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy, casProperties.getAuthn().getDigest().getRealm(), casProperties.getAuthn().getDigest().getAuthenticationMethod(), defaultDigestCredentialRetriever);
    }

    @ConditionalOnMissingBean(name={"defaultDigestCredentialRetriever"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public DigestHashedCredentialRetriever defaultDigestCredentialRetriever(CasConfigurationProperties casProperties) {
        DigestProperties digest = casProperties.getAuthn().getDigest();
        return new DefaultDigestHashedCredentialRetriever(digest.getUsers());
    }

    @Bean
    @ConditionalOnMissingBean(name={"digestAuthenticationCasWebflowExecutionPlanConfigurer"})
    public CasWebflowExecutionPlanConfigurer digestAuthenticationCasWebflowExecutionPlanConfigurer(@Qualifier(value="digestAuthenticationWebflowConfigurer") CasWebflowConfigurer digestAuthenticationWebflowConfigurer) {
        return plan -> plan.registerWebflowConfigurer(digestAuthenticationWebflowConfigurer);
    }
}

