/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.digest.web.flow;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.config.CasCoreMultifactorAuthenticationConfiguration;
import org.apereo.cas.digest.DigestCredential;
import org.apereo.cas.digest.config.DigestAuthenticationConfiguration;
import org.apereo.cas.digest.config.support.authentication.DigestAuthenticationComponentSerializationConfiguration;
import org.apereo.cas.digest.config.support.authentication.DigestAuthenticationEventExecutionPlanConfiguration;
import org.apereo.cas.web.flow.BaseWebflowConfigurerTests;
import org.apereo.cas.web.flow.config.CasMultifactorAuthenticationWebflowConfiguration;
import org.apereo.cas.web.support.WebUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.mock.web.MockServletContext;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.Action;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.test.MockRequestContext;

@SpringBootTest(classes={DigestAuthenticationConfiguration.class, DigestAuthenticationEventExecutionPlanConfiguration.class, DigestAuthenticationComponentSerializationConfiguration.class, CasCoreMultifactorAuthenticationConfiguration.class, CasMultifactorAuthenticationWebflowConfiguration.class, BaseWebflowConfigurerTests.SharedTestConfiguration.class}, properties={"cas.authn.digest.users.casuser=1234567890"})
@Tag(value="WebflowActions")
public class DigestAuthenticationActionTests {
    @Autowired
    @Qualifier(value="digestAuthenticationAction")
    private Action digestAuthenticationAction;

    @Test
    public void verifyNoAuthn() throws Exception {
        Assertions.assertNotNull((Object)this.digestAuthenticationAction);
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        Event result = this.digestAuthenticationAction.execute((RequestContext)context);
        Assertions.assertEquals((Object)"error", (Object)result.getId());
        Assertions.assertEquals((int)401, (int)response.getStatus());
    }

    @Test
    public void verifyBadDigest() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        request.addHeader("Authorization", (Object)"Digest 1234567890");
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        Event result = this.digestAuthenticationAction.execute((RequestContext)context);
        Assertions.assertEquals((Object)"error", (Object)result.getId());
    }

    @Test
    public void verifyDigest() throws Exception {
        MockRequestContext context = new MockRequestContext();
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        context.setExternalContext((ExternalContext)new ServletExternalContext((ServletContext)new MockServletContext(), (HttpServletRequest)request, (HttpServletResponse)response));
        Event result = this.digestAuthenticationAction.execute((RequestContext)context);
        Assertions.assertEquals((Object)"error", (Object)result.getId());
        String header = response.getHeader("WWW-Authenticate");
        Assertions.assertNotNull((Object)header);
        String digest = "username=\"casuser\",realm=\"CAS\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",uri=\"/login\",qop=auth,nc=00000001,cnonce=\"0a4f113b\",response=\"bad-client-response-digest\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"";
        request.addHeader("Authorization", (Object)("Digest " + digest));
        result = this.digestAuthenticationAction.execute((RequestContext)context);
        Assertions.assertEquals((Object)"error", (Object)result.getId());
        Assertions.assertEquals((int)401, (int)response.getStatus());
        digest = "username=\"casuser\",realm=\"CAS\",nonce=\"dcd98b7102dd2f0e8b11d0f600bfb0c093\",uri=\"/login\",qop=auth,nc=00000001,cnonce=\"0a4f113b\",response=\"68a7c1eb3464e1c6c74adb230df614b8\",opaque=\"5ccc069c403ebaf9f0171e9517f40e41\"";
        request.removeHeader("Authorization");
        request.addHeader("Authorization", (Object)("Digest " + digest));
        result = this.digestAuthenticationAction.execute((RequestContext)context);
        Assertions.assertEquals((Object)"success", (Object)result.getId());
        Assertions.assertTrue((boolean)(WebUtils.getCredential((RequestContext)context) instanceof DigestCredential));
    }
}

