/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.digest;

import java.security.GeneralSecurityException;
import javax.security.auth.login.FailedLoginException;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.AbstractAuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetaData;
import org.apereo.cas.authentication.DefaultAuthenticationHandlerExecutionResult;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.digest.DigestCredential;
import org.apereo.cas.services.ServicesManager;

public class DigestAuthenticationHandler
extends AbstractAuthenticationHandler {
    public DigestAuthenticationHandler(String name, ServicesManager servicesManager, PrincipalFactory principalFactory, Integer order) {
        super(name, servicesManager, principalFactory, order);
    }

    public AuthenticationHandlerExecutionResult authenticate(Credential credential) throws GeneralSecurityException {
        DigestCredential c = (DigestCredential)credential;
        if (StringUtils.isNotBlank((CharSequence)c.getId()) && StringUtils.isNotBlank((CharSequence)c.getHash())) {
            return new DefaultAuthenticationHandlerExecutionResult((AuthenticationHandler)this, (CredentialMetaData)c, this.principalFactory.createPrincipal(c.getId()));
        }
        throw new FailedLoginException("Could not authenticate " + c.getId());
    }

    public boolean supports(Credential credential) {
        return credential instanceof DigestCredential;
    }

    public boolean supports(Class<? extends Credential> clazz) {
        return DigestCredential.class.isAssignableFrom(clazz);
    }
}

