/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.digest.web.flow;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.AdaptiveAuthenticationPolicy;
import org.apereo.cas.digest.DigestCredential;
import org.apereo.cas.digest.DigestHashedCredentialRetriever;
import org.apereo.cas.digest.util.DigestAuthenticationUtils;
import org.apereo.cas.web.flow.actions.AbstractNonInteractiveCredentialsAction;
import org.apereo.cas.web.flow.resolver.CasDelegatingWebflowEventResolver;
import org.apereo.cas.web.flow.resolver.CasWebflowEventResolver;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.J2ESessionStore;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.http.credentials.DigestCredentials;
import org.pac4j.http.credentials.extractor.DigestAuthExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class DigestAuthenticationAction
extends AbstractNonInteractiveCredentialsAction {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DigestAuthenticationAction.class);
    private final String nonce = DigestAuthenticationUtils.createNonce();
    private final DigestHashedCredentialRetriever credentialRetriever;
    private final String realm;
    private final String authenticationMethod;

    public DigestAuthenticationAction(CasDelegatingWebflowEventResolver initialAuthenticationAttemptWebflowEventResolver, CasWebflowEventResolver serviceTicketRequestWebflowEventResolver, AdaptiveAuthenticationPolicy adaptiveAuthenticationPolicy, String realm, String authenticationMethod, DigestHashedCredentialRetriever credentialRetriever) {
        super(initialAuthenticationAttemptWebflowEventResolver, serviceTicketRequestWebflowEventResolver, adaptiveAuthenticationPolicy);
        this.realm = realm;
        this.authenticationMethod = authenticationMethod;
        this.credentialRetriever = credentialRetriever;
    }

    protected Credential constructCredentialsFromRequest(RequestContext requestContext) {
        try {
            HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)requestContext);
            HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext((RequestContext)requestContext);
            DigestAuthExtractor extractor = new DigestAuthExtractor();
            J2EContext webContext = new J2EContext(request, response, (SessionStore)new J2ESessionStore());
            DigestCredentials credentials = extractor.extract((WebContext)webContext);
            if (credentials == null) {
                response.addHeader("WWW-Authenticate", DigestAuthenticationUtils.createAuthenticateHeader(this.realm, this.authenticationMethod, this.nonce));
                response.setStatus(401);
                return null;
            }
            LOGGER.debug("Received digest authentication request from credentials [{}] ", (Object)credentials);
            String serverResponse = credentials.calculateServerDigest(true, this.credentialRetriever.findCredential(credentials.getUsername(), this.realm));
            String clientResponse = credentials.getToken();
            if (!serverResponse.equals(clientResponse)) {
                response.setStatus(401);
                return null;
            }
            return new DigestCredential(credentials.getUsername(), this.realm, credentials.getToken());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

