/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.digest;

import java.util.Collections;
import javax.security.auth.login.AccountNotFoundException;
import lombok.Generated;
import org.apereo.cas.digest.DefaultDigestHashedCredentialRetriever;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDigestHashedCredentialRetrieverTests {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDigestHashedCredentialRetrieverTests.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void verifyCanFindAnExistingUser() throws Exception {
        String expectedPassword = "password";
        DefaultDigestHashedCredentialRetriever credentialRetriever = new DefaultDigestHashedCredentialRetriever(Collections.singletonMap("user", "password"));
        String credential = credentialRetriever.findCredential("user", "ignored");
        Assert.assertEquals((Object)"password", (Object)credential);
    }

    @Test
    public void verifyAnExceptionIsThrownIfUsedDoesNotExist() throws Exception {
        String username = "user";
        DefaultDigestHashedCredentialRetriever credentialRetriever = new DefaultDigestHashedCredentialRetriever(Collections.singletonMap("anotherUsername", "password"));
        this.thrown.expect(AccountNotFoundException.class);
        credentialRetriever.findCredential("user", "ignored");
    }
}

