/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.digest.util;

import java.security.SecureRandom;
import java.time.ZonedDateTime;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.auth.DigestScheme;

public final class DigestAuthenticationUtils {
    private DigestAuthenticationUtils() {
    }

    public static String createNonce() {
        String fmtDate = ZonedDateTime.now().toString();
        SecureRandom rand = new SecureRandom();
        Integer randomInt = rand.nextInt();
        return DigestUtils.md5Hex((String)(fmtDate + randomInt));
    }

    public static String createCnonce() {
        return DigestScheme.createCnonce();
    }

    public static String createOpaque(String domain, String nonce) {
        return DigestUtils.md5Hex((String)(domain + nonce));
    }

    public static String createAuthenticateHeader(String realm, String authMethod, String nonce) {
        StringBuilder stringBuilder = new StringBuilder("Digest realm=\"").append(realm).append("\",");
        if (StringUtils.isNotBlank((CharSequence)authMethod)) {
            stringBuilder.append("qop=").append(authMethod).append(',');
        }
        return stringBuilder.append("nonce=\"").append(nonce).append("\",opaque=\"").append(DigestAuthenticationUtils.createOpaque(realm, nonce)).append('\"').toString();
    }
}

