/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.digest.web.flow;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.digest.DigestCredential;
import org.apereo.cas.digest.DigestHashedCredentialRetriever;
import org.apereo.cas.digest.util.DigestAuthenticationUtils;
import org.apereo.cas.web.flow.AbstractNonInteractiveCredentialsAction;
import org.apereo.cas.web.support.WebUtils;
import org.pac4j.core.context.J2EContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.http.credentials.DigestCredentials;
import org.pac4j.http.credentials.extractor.DigestAuthExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class DigestAuthenticationAction
extends AbstractNonInteractiveCredentialsAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(DigestAuthenticationAction.class);
    private String nonce = DigestAuthenticationUtils.createNonce();
    private DigestHashedCredentialRetriever credentialRetriever;
    private String realm = "CAS";
    private String authenticationMethod = "auth";

    public void setCredentialRetriever(DigestHashedCredentialRetriever credentialRetriever) {
        this.credentialRetriever = credentialRetriever;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public void setAuthenticationMethod(String authenticationMethod) {
        this.authenticationMethod = authenticationMethod;
    }

    protected Credential constructCredentialsFromRequest(RequestContext requestContext) {
        try {
            HttpServletRequest request = WebUtils.getHttpServletRequest((RequestContext)requestContext);
            HttpServletResponse response = WebUtils.getHttpServletResponse((RequestContext)requestContext);
            DigestAuthExtractor extractor = new DigestAuthExtractor(((Object)((Object)this)).getClass().getSimpleName());
            J2EContext webContext = new J2EContext(request, response);
            DigestCredentials credentials = extractor.extract((WebContext)webContext);
            if (credentials == null) {
                response.addHeader("WWW-Authenticate", DigestAuthenticationUtils.createAuthenticateHeader(this.realm, this.authenticationMethod, this.nonce));
                response.setStatus(401);
                return null;
            }
            LOGGER.debug("Received digest authentication request from credentials {} ", (Object)credentials);
            String serverResponse = credentials.calculateServerDigest(true, this.credentialRetriever.findCredential(credentials.getUsername(), this.realm));
            String clientResponse = credentials.getToken();
            if (!serverResponse.equals(clientResponse)) {
                response.setStatus(401);
                return null;
            }
            return new DigestCredential(credentials.getUsername(), this.realm, credentials.getToken());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

