/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.digest.util;

import java.security.SecureRandom;
import java.time.ZonedDateTime;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.impl.auth.DigestScheme;

public final class DigestAuthenticationUtils {
    private DigestAuthenticationUtils() {
    }

    public static String createNonce() {
        String fmtDate = ZonedDateTime.now().toString();
        SecureRandom rand = new SecureRandom();
        Integer randomInt = rand.nextInt();
        return DigestUtils.md5Hex((String)(fmtDate + randomInt.toString()));
    }

    public static String createCnonce() {
        return DigestScheme.createCnonce();
    }

    public static String createOpaque(String domain, String nonce) {
        return DigestUtils.md5Hex((String)(domain + nonce));
    }

    public static String createAuthenticateHeader(String realm, String authMethod, String nonce) {
        String header = "";
        header = header + "Digest realm=\"" + realm + "\",";
        if (StringUtils.isNotBlank((CharSequence)authMethod)) {
            header = header + "qop=" + authMethod + ",";
        }
        header = header + "nonce=\"" + nonce + "\",";
        header = header + "opaque=\"" + DigestAuthenticationUtils.createOpaque(realm, nonce) + "\"";
        return header;
    }
}

