/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.digest.config;

import java.util.Map;
import javax.annotation.PostConstruct;
import org.apereo.cas.CentralAuthenticationService;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.principal.DefaultPrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalFactory;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.digest.DefaultDigestHashedCredentialRetriever;
import org.apereo.cas.digest.DigestAuthenticationHandler;
import org.apereo.cas.digest.DigestHashedCredentialRetriever;
import org.apereo.cas.digest.web.flow.DigestAuthenticationAction;
import org.apereo.cas.digest.web.flow.DigestAuthenticationWebflowConfigurer;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.web.flow.CasWebflowConfigurer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.util.CookieGenerator;
import org.springframework.webflow.definition.registry.FlowDefinitionRegistry;
import org.springframework.webflow.engine.builder.support.FlowBuilderServices;

@Configuration(value="digestAuthenticationConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class DigestAuthenticationConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    @Qualifier(value="servicesManager")
    private ServicesManager servicesManager;
    @Autowired
    @Qualifier(value="authenticationHandlersResolvers")
    private Map authenticationHandlersResolvers;
    @Autowired
    @Qualifier(value="warnCookieGenerator")
    private CookieGenerator warnCookieGenerator;
    @Autowired
    @Qualifier(value="loginFlowRegistry")
    private FlowDefinitionRegistry loginFlowDefinitionRegistry;
    @Autowired
    @Qualifier(value="centralAuthenticationService")
    private CentralAuthenticationService centralAuthenticationService;
    @Autowired
    @Qualifier(value="defaultAuthenticationSystemSupport")
    private AuthenticationSystemSupport authenticationSystemSupport;
    @Autowired
    @Qualifier(value="personDirectoryPrincipalResolver")
    private PrincipalResolver personDirectoryPrincipalResolver;
    @Autowired
    private FlowBuilderServices flowBuilderServices;

    @Bean
    public PrincipalFactory digestAuthenticationPrincipalFactory() {
        return new DefaultPrincipalFactory();
    }

    @ConditionalOnMissingBean(name={"digestAuthenticationWebflowConfigurer"})
    @Bean
    public CasWebflowConfigurer digestAuthenticationWebflowConfigurer() {
        DigestAuthenticationWebflowConfigurer w = new DigestAuthenticationWebflowConfigurer();
        w.setLoginFlowDefinitionRegistry(this.loginFlowDefinitionRegistry);
        w.setFlowBuilderServices(this.flowBuilderServices);
        return w;
    }

    @Autowired
    @RefreshScope
    @Bean
    public DigestAuthenticationAction digestAuthenticationAction(@Qualifier(value="defaultDigestCredentialRetriever") DigestHashedCredentialRetriever defaultDigestCredentialRetriever) {
        DigestAuthenticationAction w = new DigestAuthenticationAction();
        w.setWarnCookieGenerator(this.warnCookieGenerator);
        w.setAuthenticationSystemSupport(this.authenticationSystemSupport);
        w.setCentralAuthenticationService(this.centralAuthenticationService);
        w.setPrincipalFactory(this.digestAuthenticationPrincipalFactory());
        w.setRealm(this.casProperties.getAuthn().getDigest().getRealm());
        w.setAuthenticationMethod(this.casProperties.getAuthn().getDigest().getAuthenticationMethod());
        w.setCredentialRetriever(defaultDigestCredentialRetriever);
        return w;
    }

    @ConditionalOnMissingBean(name={"defaultDigestCredentialRetriever"})
    @Bean
    @RefreshScope
    public DigestHashedCredentialRetriever defaultDigestCredentialRetriever() {
        DefaultDigestHashedCredentialRetriever r = new DefaultDigestHashedCredentialRetriever();
        this.casProperties.getAuthn().getDigest().getUsers().forEach((k, v) -> {
            String cfr_ignored_0 = (String)r.getStore().put(k, (Object)this.casProperties.getAuthn().getDigest().getRealm(), v);
        });
        return r;
    }

    @Bean
    @RefreshScope
    public AuthenticationHandler digestAuthenticationHandler() {
        DigestAuthenticationHandler r = new DigestAuthenticationHandler();
        r.setPrincipalFactory(this.digestAuthenticationPrincipalFactory());
        r.setServicesManager(this.servicesManager);
        return r;
    }

    @PostConstruct
    public void initializeAuthenticationHandler() {
        this.authenticationHandlersResolvers.put(this.digestAuthenticationHandler(), this.personDirectoryPrincipalResolver);
    }
}

