/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.ticket;

import com.azure.cosmos.CosmosContainer;
import com.azure.cosmos.implementation.NotFoundException;
import com.azure.cosmos.models.CosmosBulkOperations;
import com.azure.cosmos.models.CosmosItemRequestOptions;
import com.azure.cosmos.models.CosmosItemResponse;
import com.azure.cosmos.models.CosmosQueryRequestOptions;
import com.azure.cosmos.models.PartitionKey;
import com.azure.cosmos.util.CosmosPagedIterable;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.ticket.CosmosDbTicketDocument;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.TicketDefinition;
import org.apereo.cas.ticket.registry.AbstractTicketRegistry;
import org.apereo.cas.ticket.serialization.TicketSerializationManager;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;

public class CosmosDbTicketRegistry
extends AbstractTicketRegistry {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CosmosDbTicketRegistry.class);
    public static final String PARTITION_KEY_PREFIX = "prefix";
    private final List<CosmosContainer> cosmosContainers;

    public CosmosDbTicketRegistry(CipherExecutor cipherExecutor, TicketSerializationManager ticketSerializationManager, TicketCatalog ticketCatalog, List<CosmosContainer> cosmosContainers) {
        super(cipherExecutor, ticketSerializationManager, ticketCatalog);
        this.cosmosContainers = cosmosContainers;
    }

    public Ticket getTicket(String ticketId, Predicate<Ticket> predicate) {
        try {
            TicketDefinition metadata;
            String encTicketId = this.digestIdentifier(ticketId);
            TicketDefinition ticketDefinition = metadata = StringUtils.isNotBlank((CharSequence)ticketId) ? this.ticketCatalog.find(ticketId) : null;
            if (metadata == null || StringUtils.isBlank((CharSequence)encTicketId)) {
                return null;
            }
            CosmosContainer container = this.getTicketContainer(metadata);
            LOGGER.debug("Reading ticket with id [{}] from [{}]", (Object)encTicketId, (Object)container.getId());
            CosmosDbTicketDocument ticketHolder = (CosmosDbTicketDocument)container.readItem(encTicketId, new PartitionKey((Object)metadata.getPrefix()), CosmosDbTicketDocument.class).getItem();
            Ticket result = this.decodeTicket(ticketHolder.getTicket());
            return predicate != null && predicate.test(result) ? result : null;
        }
        catch (NotFoundException e) {
            LOGGER.debug("Ticket id [{}] cannot be found", (Object)ticketId);
            return null;
        }
    }

    public long deleteAll() {
        CosmosQueryRequestOptions queryOptions = new CosmosQueryRequestOptions();
        return this.ticketCatalog.findAll().stream().map(defn -> Pair.of((Object)defn, (Object)this.getTicketContainer((TicketDefinition)defn))).mapToLong(pair -> {
            CosmosContainer container = (CosmosContainer)pair.getValue();
            CosmosPagedIterable items = container.queryItems("SELECT * FROM " + container.getId(), queryOptions, CosmosDbTicketDocument.class);
            List queries = StreamSupport.stream(items.iterableByPage().spliterator(), false).map(response -> response.getResults().stream().map(doc -> CosmosBulkOperations.getDeleteItemOperation((String)doc.getId(), (PartitionKey)new PartitionKey((Object)((TicketDefinition)pair.getKey()).getPrefix()))).collect(Collectors.toList())).flatMap(Collection::stream).toList();
            return Iterables.size((Iterable)((CosmosContainer)pair.getValue()).executeBulkOperations(queries));
        }).sum();
    }

    public Collection<? extends Ticket> getTickets() {
        List<CompletableFuture> readOps = this.ticketCatalog.findAll().stream().map(defn -> {
            CosmosContainer container = this.getTicketContainer((TicketDefinition)defn);
            return CompletableFuture.supplyAsync(() -> {
                LOGGER.trace("Reading tickets in container [{}]", (Object)defn.getPrefix());
                return container.readAllItems(new PartitionKey((Object)defn.getPrefix()), CosmosDbTicketDocument.class).stream().toList();
            });
        }).toList();
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(readOps.toArray(new CompletableFuture[0]));
        CompletionStage allCompletableFuture = ((CompletableFuture)allFutures.thenApply(future -> readOps.stream().map(CompletableFuture::join).collect(Collectors.toList()))).thenApply(list -> list.stream().flatMap(Collection::stream).map(doc -> this.decodeTicket(doc.getTicket())).collect(Collectors.toList()));
        return (Collection)FunctionUtils.doUnchecked(((CompletableFuture)allCompletableFuture)::get);
    }

    public Ticket updateTicket(Ticket ticket) throws Exception {
        return this.addTicket(ticket);
    }

    public long deleteSingleTicket(Ticket ticketToDelete) {
        String encTicketId = this.digestIdentifier(ticketToDelete.getId());
        TicketDefinition metadata = this.ticketCatalog.find(ticketToDelete);
        CosmosContainer container = this.getTicketContainer(metadata);
        CosmosItemResponse result = container.deleteItem(encTicketId, new PartitionKey((Object)metadata.getPrefix()), new CosmosItemRequestOptions());
        return HttpStatus.valueOf((int)result.getStatusCode()).is2xxSuccessful() ? 1L : 0L;
    }

    protected Ticket addSingleTicket(Ticket ticket) throws Exception {
        TicketDefinition metadata = this.ticketCatalog.find(ticket);
        CosmosContainer container = this.getTicketContainer(metadata);
        CosmosDbTicketDocument holder = this.getCosmosDbTicketDocument(ticket, metadata);
        container.upsertItem((Object)holder);
        return ticket;
    }

    public List<? extends Ticket> addTicket(Stream<? extends Ticket> toSave) {
        HashMap<String, List> operations = new HashMap<String, List>();
        List<Ticket> results = toSave.peek(ticket -> {
            TicketDefinition ticketDefinition = this.ticketCatalog.find(ticket);
            CosmosDbTicketDocument holder = this.getCosmosDbTicketDocument((Ticket)ticket, ticketDefinition);
            List commands = operations.getOrDefault(ticketDefinition.getProperties().getStorageName(), new ArrayList());
            commands.add(CosmosBulkOperations.getCreateItemOperation((Object)holder, (PartitionKey)new PartitionKey((Object)ticketDefinition.getPrefix())));
            operations.put(ticketDefinition.getProperties().getStorageName(), commands);
        }).toList();
        operations.forEach((key, value) -> {
            CosmosContainer container = this.getTicketContainer((String)key);
            Iterable result = container.executeBulkOperations((Iterable)value);
            result.forEach(r -> {
                if (r.getResponse().getStatusCode() == HttpStatus.TOO_MANY_REQUESTS.value()) {
                    container.executeBulkOperations(List.of(r.getOperation()));
                }
            });
        });
        return results;
    }

    private CosmosDbTicketDocument getCosmosDbTicketDocument(Ticket ticket, TicketDefinition metadata) {
        return (CosmosDbTicketDocument)FunctionUtils.doUnchecked(() -> {
            Ticket encTicket = this.encodeTicket(ticket);
            Long ttl = ticket.getExpirationPolicy().getTimeToLive();
            return ((CosmosDbTicketDocument.CosmosDbTicketDocumentBuilder)((CosmosDbTicketDocument.CosmosDbTicketDocumentBuilder)((CosmosDbTicketDocument.CosmosDbTicketDocumentBuilder)((CosmosDbTicketDocument.CosmosDbTicketDocumentBuilder)((CosmosDbTicketDocument.CosmosDbTicketDocumentBuilder)((CosmosDbTicketDocument.CosmosDbTicketDocumentBuilder)CosmosDbTicketDocument.builder().id(encTicket.getId())).type(metadata.getImplementationClass().getName())).principal(this.digestIdentifier(CosmosDbTicketRegistry.getPrincipalIdFrom((Ticket)ticket)))).timeToLive(ttl)).ticket(encTicket)).prefix(metadata.getPrefix())).build();
        });
    }

    private CosmosContainer getTicketContainer(TicketDefinition metadata) {
        String mapName = metadata.getProperties().getStorageName();
        LOGGER.debug("Locating container [{}] for ticket definition [{}]", (Object)mapName, (Object)metadata);
        return this.getTicketContainer(mapName);
    }

    private CosmosContainer getTicketContainer(String containerId) {
        return this.cosmosContainers.stream().filter(cosmosContainer -> cosmosContainer.getId().equalsIgnoreCase(containerId)).findFirst().orElseThrow();
    }
}

