/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import com.azure.cosmos.CosmosContainer;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.core.util.EncryptionRandomizedSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.cosmosdb.BaseCosmosDbProperties;
import org.apereo.cas.cosmosdb.CosmosDbObjectFactory;
import org.apereo.cas.ticket.CosmosDbTicketRegistry;
import org.apereo.cas.ticket.TicketCatalog;
import org.apereo.cas.ticket.catalog.CasTicketCatalogConfigurationValuesProvider;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.ticket.serialization.TicketSerializationManager;
import org.apereo.cas.util.CoreTicketUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.TicketRegistry}, module="cosmosdb")
@AutoConfiguration
public class CasCosmosDbTicketRegistryAutoConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCosmosDbTicketRegistryAutoConfiguration.class);

    @ConditionalOnMissingBean(name={"cosmosDbTicketCatalogConfigurationValuesProvider"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CasTicketCatalogConfigurationValuesProvider cosmodDbTicketCatalogConfigurationValuesProvider() {
        return new CasTicketCatalogConfigurationValuesProvider(this){};
    }

    @ConditionalOnMissingBean(name={"cosmosDbTicketRegistryObjectFactory"})
    @Bean
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public CosmosDbObjectFactory cosmosDbTicketRegistryObjectFactory(@Qualifier(value="casSslContext") CasSSLContext casSslContext, CasConfigurationProperties casProperties) {
        return new CosmosDbObjectFactory((BaseCosmosDbProperties)casProperties.getTicket().getRegistry().getCosmosDb(), casSslContext);
    }

    @Bean
    @ConditionalOnMissingBean(name={"cosmosDbTicketRegistry"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public TicketRegistry ticketRegistry(CasConfigurationProperties casProperties, @Qualifier(value="ticketSerializationManager") TicketSerializationManager ticketSerializationManager, @Qualifier(value="ticketCatalog") TicketCatalog ticketCatalog, @Qualifier(value="cosmosDbTicketRegistryObjectFactory") CosmosDbObjectFactory cosmosDbTicketRegistryObjectFactory) {
        cosmosDbTicketRegistryObjectFactory.createDatabaseIfNecessary();
        Collection ticketDefinitions = ticketCatalog.findAll();
        List<CosmosContainer> containers = ticketDefinitions.stream().map(defn -> {
            LOGGER.debug("Creating CosmosDb container [{}] for [{}]:[{}]", new Object[]{defn.getProperties().getStorageName(), defn.getPrefix(), defn.getApiClass().getSimpleName()});
            return cosmosDbTicketRegistryObjectFactory.createContainer(defn.getProperties().getStorageName(), Long.valueOf(defn.getProperties().getStorageTimeout()), new String[]{"prefix"});
        }).toList();
        CipherExecutor cipher = CoreTicketUtils.newTicketRegistryCipherExecutor((EncryptionRandomizedSigningJwtCryptographyProperties)casProperties.getTicket().getRegistry().getCosmosDb().getCrypto(), (String)"cosmos-db");
        return new CosmosDbTicketRegistry(cipher, ticketSerializationManager, ticketCatalog, containers);
    }
}

