/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.time.StopWatch;
import org.apereo.cas.authentication.CoreAuthenticationTestUtils;
import org.apereo.cas.config.CasCosmosDbTicketRegistryAutoConfiguration;
import org.apereo.cas.cosmosdb.CosmosDbObjectFactory;
import org.apereo.cas.ticket.TicketGrantingTicketImpl;
import org.apereo.cas.ticket.expiration.NeverExpiresExpirationPolicy;
import org.apereo.cas.ticket.registry.BaseTicketRegistryTests;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.util.TicketGrantingTicketIdGenerator;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.RepeatedTest;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariable;
import org.junit.jupiter.api.condition.EnabledIfEnvironmentVariables;
import org.junit.jupiter.api.parallel.ResourceLock;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Import;
import org.springframework.test.context.TestPropertySource;

@Tag(value="Azure")
@Import(value={CasCosmosDbTicketRegistryAutoConfiguration.class})
@TestPropertySource(properties={"cas.tgc.crypto.enabled=false", "cas.http-client.host-name-verifier=none", "cas.ticket.registry.cosmos-db.uri=${#environmentVariables['COSMOS_DB_URL']}", "cas.ticket.registry.cosmos-db.key=${#environmentVariables['COSMOS_DB_KEY']}", "cas.ticket.registry.cosmos-db.database=CasTicketRegistryDb", "cas.ticket.registry.cosmos-db.database-throughput=1000", "cas.ticket.registry.cosmos-db.max-retry-attempts-on-throttled-requests=5", "cas.ticket.registry.cosmos-db.indexing-mode=CONSISTENT"})
@ResourceLock(value="cosmosdb-tickets")
@EnabledIfEnvironmentVariables(value={@EnabledIfEnvironmentVariable(named="COSMOS_DB_URL", matches=".+"), @EnabledIfEnvironmentVariable(named="COSMOS_DB_KEY", matches=".+")})
class CosmosDbTicketRegistryTests
extends BaseTicketRegistryTests {
    private static final int COUNT = 10;
    @Autowired
    @Qualifier(value="ticketRegistry")
    private TicketRegistry newTicketRegistry;

    CosmosDbTicketRegistryTests() {
    }

    @RepeatedTest(value=1)
    @Tag(value="TicketRegistryTestWithEncryption")
    void verifyLargeDataset() throws Throwable {
        Stream<TicketGrantingTicketImpl> ticketGrantingTickets = Stream.generate(() -> {
            String tgtId = new TicketGrantingTicketIdGenerator(10, "").getNewTicketId("TGT");
            return new TicketGrantingTicketImpl(tgtId, CoreAuthenticationTestUtils.getAuthentication(), NeverExpiresExpirationPolicy.INSTANCE);
        }).limit(10L);
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        this.newTicketRegistry.addTicket(ticketGrantingTickets);
        int size = this.newTicketRegistry.getTickets().size();
        stopwatch.stop();
        Assertions.assertEquals((int)10, (int)size);
        long time = stopwatch.getTime(TimeUnit.SECONDS);
        Assertions.assertTrue((time <= 20L ? 1 : 0) != 0);
    }

    @AfterAll
    public static void shutdown() {
        CosmosDbObjectFactory factory = (CosmosDbObjectFactory)ApplicationContextProvider.getApplicationContext().getBean(CosmosDbObjectFactory.class);
        factory.dropDatabase();
    }

    @Generated
    public TicketRegistry getNewTicketRegistry() {
        return this.newTicketRegistry;
    }
}

