/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.cassandra.services;

import lombok.Generated;
import org.apereo.cas.config.CassandraServiceRegistryAutoConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.AbstractServiceRegistryTests;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.test.CasTestExtension;
import org.apereo.cas.util.junit.EnabledIfListeningOnPort;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.MethodOrderer;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestMethodOrder;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

@SpringBootTest(classes={CassandraServiceRegistryAutoConfiguration.class, AbstractServiceRegistryTests.SharedTestConfiguration.class}, properties={"cas.service-registry.cassandra.local-dc=datacenter1", "cas.service-registry.cassandra.keyspace=cas", "cas.service-registry.cassandra.ssl-protocols=TLSv1.2", "cas.http-client.host-name-verifier=none"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
@Tag(value="Cassandra")
@ExtendWith(value={CasTestExtension.class})
@TestMethodOrder(value=MethodOrderer.OrderAnnotation.class)
@EnabledIfListeningOnPort(port={9042})
@TestExecutionListeners(value={DependencyInjectionTestExecutionListener.class, DisposingTestExecutionListener.class})
class CassandraServiceRegistryTests
extends AbstractServiceRegistryTests {
    @Autowired
    @Qualifier(value="cassandraServiceRegistry")
    private ServiceRegistry newServiceRegistry;

    CassandraServiceRegistryTests() {
    }

    @Test
    @Order(value=0x7FFFFFFF)
    void verifyFailOps() throws Throwable {
        Assertions.assertNull((Object)this.newServiceRegistry.save((RegisteredService)null));
        Assertions.assertFalse((boolean)this.newServiceRegistry.delete(null));
    }

    @Generated
    public ServiceRegistry getNewServiceRegistry() {
        return this.newServiceRegistry;
    }

    static class DisposingTestExecutionListener
    implements TestExecutionListener {
        DisposingTestExecutionListener() {
        }

        public void afterTestClass(TestContext testContext) throws Exception {
            ServiceRegistry registry = (ServiceRegistry)testContext.getApplicationContext().getBean("cassandraServiceRegistry", ServiceRegistry.class);
            ((DisposableBean)registry).destroy();
        }
    }
}

