/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.cassandra.services;

import lombok.Generated;
import org.apereo.cas.config.CasCoreHttpConfiguration;
import org.apereo.cas.config.CasCoreNotificationsConfiguration;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.config.CasCoreUtilConfiguration;
import org.apereo.cas.config.CassandraServiceRegistryConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.AbstractServiceRegistryTests;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.util.junit.EnabledIfPortOpen;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.cloud.autoconfigure.RefreshAutoConfiguration;
import org.springframework.scheduling.annotation.EnableScheduling;

@SpringBootTest(classes={CassandraServiceRegistryConfiguration.class, CasCoreServicesConfiguration.class, CasCoreNotificationsConfiguration.class, CasCoreUtilConfiguration.class, CasCoreHttpConfiguration.class, RefreshAutoConfiguration.class}, properties={"cas.service-registry.cassandra.local-dc=datacenter1", "cas.service-registry.cassandra.keyspace=cas"})
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@EnableScheduling
@Tag(value="Cassandra")
@EnabledIfPortOpen(port={9042})
public class CassandraServiceRegistryTests
extends AbstractServiceRegistryTests {
    @Autowired
    @Qualifier(value="cassandraServiceRegistry")
    private ServiceRegistry newServiceRegistry;

    @Test
    public void verifyFailOps() throws Exception {
        Assertions.assertNull((Object)this.newServiceRegistry.save(null));
        Assertions.assertFalse((boolean)this.newServiceRegistry.delete(null));
        if (this.newServiceRegistry instanceof DisposableBean) {
            ((DisposableBean)DisposableBean.class.cast(this.newServiceRegistry)).destroy();
        }
    }

    @Generated
    public ServiceRegistry getNewServiceRegistry() {
        return this.newServiceRegistry;
    }
}

