/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services.cassandra;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.cassandra.CassandraSessionFactory;
import org.apereo.cas.configuration.model.support.cassandra.serviceregistry.CassandraServiceRegistryProperties;
import org.apereo.cas.configuration.support.Beans;
import org.apereo.cas.services.AbstractServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.services.cassandra.CassandraRegisteredServiceHolder;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.data.cassandra.core.EntityWriteResult;
import org.springframework.data.cassandra.core.InsertOptions;
import org.springframework.data.cassandra.core.query.CriteriaDefinition;
import org.springframework.data.cassandra.core.query.Query;

public class CassandraServiceRegistry
extends AbstractServiceRegistry
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraServiceRegistry.class);
    private static final StringSerializer<RegisteredService> SERIALIZER = new RegisteredServiceJsonSerializer((PrettyPrinter)new MinimalPrettyPrinter());
    private final CassandraSessionFactory cassandraSessionFactory;
    private final CassandraServiceRegistryProperties properties;

    public CassandraServiceRegistry(CassandraSessionFactory cassandraSessionFactory, CassandraServiceRegistryProperties properties, ConfigurableApplicationContext applicationContext, Collection<ServiceRegistryListener> serviceRegistryListeners) {
        super(applicationContext, serviceRegistryListeners);
        this.properties = properties;
        this.cassandraSessionFactory = cassandraSessionFactory;
    }

    public RegisteredService save(RegisteredService rs) {
        try {
            String data = SERIALIZER.toString((Object)rs);
            this.invokeServiceRegistryListenerPreSave(rs);
            InsertOptions options = InsertOptions.builder().consistencyLevel((ConsistencyLevel)DefaultConsistencyLevel.valueOf((String)this.properties.getConsistencyLevel())).serialConsistencyLevel((ConsistencyLevel)DefaultConsistencyLevel.valueOf((String)this.properties.getSerialConsistencyLevel())).timeout(Beans.newDuration((String)this.properties.getTimeout())).build();
            EntityWriteResult result = this.cassandraSessionFactory.getCassandraTemplate().insert((Object)new CassandraRegisteredServiceHolder(rs.getId(), data), options);
            return (RegisteredService)SERIALIZER.from(((CassandraRegisteredServiceHolder)result.getEntity()).getData());
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return rs;
        }
    }

    public boolean delete(RegisteredService registeredService) {
        try {
            this.cassandraSessionFactory.getCassandraTemplate().deleteById((Object)registeredService.getId(), CassandraRegisteredServiceHolder.class);
            return true;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return false;
        }
    }

    public long size() {
        return this.cassandraSessionFactory.getCassandraTemplate().count(CassandraRegisteredServiceHolder.class);
    }

    public Collection<RegisteredService> load() {
        List results = this.cassandraSessionFactory.getCassandraTemplate().select(Query.query((CriteriaDefinition[])new CriteriaDefinition[0]), CassandraRegisteredServiceHolder.class);
        return results.stream().map(holder -> (RegisteredService)SERIALIZER.from(holder.getData())).filter(Objects::nonNull).map(arg_0 -> ((CassandraServiceRegistry)this).invokeServiceRegistryListenerPostLoad(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public RegisteredService findServiceById(long id) {
        CassandraRegisteredServiceHolder holder = (CassandraRegisteredServiceHolder)this.cassandraSessionFactory.getCassandraTemplate().selectOneById((Object)id, CassandraRegisteredServiceHolder.class);
        if (holder != null) {
            return (RegisteredService)SERIALIZER.from(holder.getData());
        }
        return null;
    }

    public void destroy() throws Exception {
        this.cassandraSessionFactory.close();
    }

    @Generated
    public String toString() {
        return "CassandraServiceRegistry(cassandraSessionFactory=" + this.cassandraSessionFactory + ", properties=" + this.properties + ")";
    }
}

