/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import java.util.Collection;
import org.apereo.cas.adaptors.cassandra.services.CassandraServiceRegistry;
import org.apereo.cas.cassandra.CassandraSessionFactory;
import org.apereo.cas.cassandra.DefaultCassandraSessionFactory;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.cassandra.authentication.BaseCassandraProperties;
import org.apereo.cas.configuration.model.support.cassandra.serviceregistry.CassandraServiceRegistryProperties;
import org.apereo.cas.services.ServiceRegistry;
import org.apereo.cas.services.ServiceRegistryExecutionPlanConfigurer;
import org.apereo.cas.services.ServiceRegistryListener;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(value="cassandraServiceRegistryConfiguration")
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CassandraServiceRegistryConfiguration {
    @Autowired
    private CasConfigurationProperties casProperties;
    @Autowired
    private ConfigurableApplicationContext applicationContext;
    @Autowired
    @Qualifier(value="serviceRegistryListeners")
    private ObjectProvider<Collection<ServiceRegistryListener>> serviceRegistryListeners;

    @Bean
    @RefreshScope
    public ServiceRegistry cassandraServiceRegistry() {
        CassandraServiceRegistryProperties cassandra = this.casProperties.getServiceRegistry().getCassandra();
        return new CassandraServiceRegistry(this.cassandraServiceRegistrySessionFactory(), cassandra, (ApplicationEventPublisher)this.applicationContext, (Collection)this.serviceRegistryListeners.getObject());
    }

    @Bean
    @RefreshScope
    @ConditionalOnMissingBean(name={"cassandraServiceRegistrySessionFactory"})
    public CassandraSessionFactory cassandraServiceRegistrySessionFactory() {
        CassandraServiceRegistryProperties cassandra = this.casProperties.getServiceRegistry().getCassandra();
        return new DefaultCassandraSessionFactory((BaseCassandraProperties)cassandra);
    }

    @Bean
    @ConditionalOnMissingBean(name={"cassandraServiceRegistryExecutionPlanConfigurer"})
    public ServiceRegistryExecutionPlanConfigurer cassandraServiceRegistryExecutionPlanConfigurer() {
        return plan -> plan.registerServiceRegistry(this.cassandraServiceRegistry());
    }
}

