/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.adaptors.cassandra.services;

import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.Session;
import com.datastax.driver.mapping.Mapper;
import com.datastax.driver.mapping.MappingManager;
import com.datastax.driver.mapping.Result;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apereo.cas.adaptors.cassandra.services.CassandraRegisteredServiceHolder;
import org.apereo.cas.cassandra.CassandraSessionFactory;
import org.apereo.cas.configuration.model.support.cassandra.serviceregistry.CassandraServiceRegistryProperties;
import org.apereo.cas.services.AbstractServiceRegistry;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServiceRegistryListener;
import org.apereo.cas.services.util.RegisteredServiceJsonSerializer;
import org.apereo.cas.util.serialization.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEventPublisher;

public class CassandraServiceRegistry
extends AbstractServiceRegistry
implements DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CassandraServiceRegistry.class);
    private static final StringSerializer<RegisteredService> SERIALIZER = new RegisteredServiceJsonSerializer();
    private final Mapper<CassandraRegisteredServiceHolder> entityManager;
    private final Session cassandraSession;
    private final CassandraServiceRegistryProperties properties;

    public CassandraServiceRegistry(CassandraSessionFactory cassandraSessionFactory, CassandraServiceRegistryProperties properties, ApplicationEventPublisher eventPublisher, Collection<ServiceRegistryListener> serviceRegistryListeners) {
        super(eventPublisher, serviceRegistryListeners);
        this.properties = properties;
        this.cassandraSession = cassandraSessionFactory.getSession();
        MappingManager mappingManager = new MappingManager(this.cassandraSession);
        this.entityManager = mappingManager.mapper(CassandraRegisteredServiceHolder.class);
    }

    public RegisteredService save(RegisteredService rs) {
        try {
            String data = SERIALIZER.toString((Object)rs);
            this.invokeServiceRegistryListenerPreSave(rs);
            this.entityManager.save((Object)new CassandraRegisteredServiceHolder(rs.getId(), data), new Mapper.Option[]{this.getConsistencyLevel()});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return rs;
    }

    public boolean delete(RegisteredService registeredService) {
        try {
            this.entityManager.delete(new Object[]{registeredService.getId(), this.getConsistencyLevel()});
            return true;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    public long size() {
        try {
            String query = String.format("SELECT COUNT(*) FROM %s", "casservices");
            return this.cassandraSession.execute(query).one().getLong(0);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return 0L;
        }
    }

    public Collection<RegisteredService> load() {
        try {
            String query = String.format("SELECT id, data FROM %s", "casservices");
            ResultSet results = this.cassandraSession.execute(query);
            Result mappedResults = this.entityManager.map(results);
            return mappedResults.all().stream().map(holder -> (RegisteredService)SERIALIZER.from(holder.getData())).filter(Objects::nonNull).map(arg_0 -> ((CassandraServiceRegistry)this).invokeServiceRegistryListenerPostLoad(arg_0)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new ArrayList<RegisteredService>(0);
        }
    }

    public RegisteredService findServiceById(long id) {
        try {
            CassandraRegisteredServiceHolder holder = (CassandraRegisteredServiceHolder)this.entityManager.get(new Object[]{id});
            if (holder != null) {
                return (RegisteredService)SERIALIZER.from(holder.getData());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return null;
    }

    public void destroy() {
        this.cassandraSession.close();
    }

    private Mapper.Option getConsistencyLevel() {
        return Mapper.Option.consistencyLevel((ConsistencyLevel)ConsistencyLevel.valueOf((String)this.properties.getConsistencyLevel()));
    }

    @Generated
    public String toString() {
        return "CassandraServiceRegistry(entityManager=" + this.entityManager + ", cassandraSession=" + this.cassandraSession + ", properties=" + this.properties + ")";
    }
}

