/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.aup.AcceptableUsagePolicyRepository;
import org.apereo.cas.aup.RedisAcceptableUsagePolicyRepository;
import org.apereo.cas.authentication.CasSSLContext;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.features.CasFeatureModule;
import org.apereo.cas.configuration.model.support.aup.RedisAcceptableUsagePolicyProperties;
import org.apereo.cas.configuration.model.support.redis.BaseRedisProperties;
import org.apereo.cas.redis.core.CasRedisTemplate;
import org.apereo.cas.redis.core.RedisObjectFactory;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.spring.beans.BeanCondition;
import org.apereo.cas.util.spring.beans.BeanSupplier;
import org.apereo.cas.util.spring.boot.ConditionalOnFeatureEnabled;
import org.jooq.lambda.Unchecked;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.env.PropertyResolver;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnFeatureEnabled(feature={CasFeatureModule.FeatureCatalog.AcceptableUsagePolicy}, module="redis")
@AutoConfiguration
public class CasAcceptableUsagePolicyRedisConfiguration {
    private static final BeanCondition CONDITION_AUP_REDIS_ENABLED = BeanCondition.on((String)"cas.acceptable-usage-policy.redis.enabled").isTrue().evenIfMissing();

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"redisAcceptableUsagePolicyTemplate"})
    public CasRedisTemplate redisAcceptableUsagePolicyTemplate(ConfigurableApplicationContext applicationContext, @Qualifier(value="redisAcceptableUsagePolicyConnectionFactory") RedisConnectionFactory redisAcceptableUsagePolicyConnectionFactory) throws Exception {
        return (CasRedisTemplate)BeanSupplier.of(CasRedisTemplate.class).when(AcceptableUsagePolicyRepository.CONDITION_AUP_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).and(CONDITION_AUP_REDIS_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> RedisObjectFactory.newRedisTemplate((RedisConnectionFactory)redisAcceptableUsagePolicyConnectionFactory)).otherwiseProxy().get();
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisAcceptableUsagePolicyConnectionFactory"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public RedisConnectionFactory redisAcceptableUsagePolicyConnectionFactory(ConfigurableApplicationContext applicationContext, @Qualifier(value="casSslContext") CasSSLContext casSslContext, CasConfigurationProperties casProperties) throws Exception {
        return (RedisConnectionFactory)BeanSupplier.of(RedisConnectionFactory.class).when(AcceptableUsagePolicyRepository.CONDITION_AUP_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).and(CONDITION_AUP_REDIS_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).supply(Unchecked.supplier(() -> {
            RedisAcceptableUsagePolicyProperties redis = casProperties.getAcceptableUsagePolicy().getRedis();
            return RedisObjectFactory.newRedisConnectionFactory((BaseRedisProperties)redis, (CasSSLContext)casSslContext);
        })).otherwiseProxy().get();
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public AcceptableUsagePolicyRepository acceptableUsagePolicyRepository(CasConfigurationProperties casProperties, ConfigurableApplicationContext applicationContext, @Qualifier(value="redisAcceptableUsagePolicyTemplate") CasRedisTemplate redisAcceptableUsagePolicyTemplate, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport) throws Exception {
        return (AcceptableUsagePolicyRepository)BeanSupplier.of(AcceptableUsagePolicyRepository.class).when(AcceptableUsagePolicyRepository.CONDITION_AUP_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).and(CONDITION_AUP_REDIS_ENABLED.given((PropertyResolver)applicationContext.getEnvironment())).supply(() -> new RedisAcceptableUsagePolicyRepository(ticketRegistrySupport, casProperties.getAcceptableUsagePolicy(), redisAcceptableUsagePolicyTemplate)).otherwise(AcceptableUsagePolicyRepository::noOp).get();
    }
}

