/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.aup;

import lombok.Generated;
import org.apereo.cas.aup.BaseAcceptableUsagePolicyRepository;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.aup.AcceptableUsagePolicyProperties;
import org.apereo.cas.redis.core.CasRedisTemplate;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.webflow.execution.RequestContext;

public class RedisAcceptableUsagePolicyRepository
extends BaseAcceptableUsagePolicyRepository {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RedisAcceptableUsagePolicyRepository.class);
    public static final String CAS_AUP_PREFIX = RedisAcceptableUsagePolicyRepository.class.getSimpleName() + ":";
    private static final long serialVersionUID = 1600024683199961892L;
    private final CasRedisTemplate redisTemplate;

    public RedisAcceptableUsagePolicyRepository(TicketRegistrySupport ticketRegistrySupport, AcceptableUsagePolicyProperties aupProperties, CasRedisTemplate redisTemplate) {
        super(ticketRegistrySupport, aupProperties);
        this.redisTemplate = redisTemplate;
    }

    public boolean submit(RequestContext requestContext) {
        try {
            Principal principal = WebUtils.getAuthentication((RequestContext)requestContext).getPrincipal();
            String redisKey = CAS_AUP_PREFIX + principal.getId() + ":" + this.aupProperties.getCore().getAupAttributeName();
            this.redisTemplate.boundValueOps((Object)redisKey).set((Object)Boolean.TRUE);
            return true;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return false;
        }
    }
}

