/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import org.apereo.cas.aup.AcceptableUsagePolicyRepository;
import org.apereo.cas.aup.RedisAcceptableUsagePolicyRepository;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.support.aup.RedisAcceptableUsagePolicyProperties;
import org.apereo.cas.configuration.model.support.redis.BaseRedisProperties;
import org.apereo.cas.redis.core.RedisObjectFactory;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;

@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@ConditionalOnExpression(value="${cas.acceptable-usage-policy.core.enabled:true} and ${cas.acceptable-usage-policy.redis.enabled:true}")
@Configuration(value="casAcceptableUsagePolicyRedisConfiguration", proxyBeanMethods=false)
public class CasAcceptableUsagePolicyRedisConfiguration {
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    @ConditionalOnMissingBean(name={"redisAcceptableUsagePolicyTemplate"})
    public RedisTemplate redisAcceptableUsagePolicyTemplate(@Qualifier(value="redisAcceptableUsagePolicyConnectionFactory") RedisConnectionFactory redisAcceptableUsagePolicyConnectionFactory) {
        return RedisObjectFactory.newRedisTemplate((RedisConnectionFactory)redisAcceptableUsagePolicyConnectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(name={"redisAcceptableUsagePolicyConnectionFactory"})
    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    public RedisConnectionFactory redisAcceptableUsagePolicyConnectionFactory(CasConfigurationProperties casProperties) {
        RedisAcceptableUsagePolicyProperties redis = casProperties.getAcceptableUsagePolicy().getRedis();
        return RedisObjectFactory.newRedisConnectionFactory((BaseRedisProperties)redis);
    }

    @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
    @Bean
    public AcceptableUsagePolicyRepository acceptableUsagePolicyRepository(CasConfigurationProperties casProperties, @Qualifier(value="redisAcceptableUsagePolicyTemplate") RedisTemplate redisAcceptableUsagePolicyTemplate, @Qualifier(value="defaultTicketRegistrySupport") TicketRegistrySupport ticketRegistrySupport) {
        return new RedisAcceptableUsagePolicyRepository(ticketRegistrySupport, casProperties.getAcceptableUsagePolicy(), redisAcceptableUsagePolicyTemplate);
    }
}

